/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.utils.sp;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.vhall.appui.baselib.R;
import java.util.Set;

public class PreferenceManager {
    private static SharedPreferences mSharedPreferences;
    private static PreferenceManager mPreferenceManager;
    private static SharedPreferences.Editor editor;

    @SuppressLint(value={"CommitPrefEdits"})
    private PreferenceManager(Context cxt) {
        mSharedPreferences = cxt.getSharedPreferences(cxt.getResources().getString(R.string.app_name), 0);
        editor = mSharedPreferences.edit();
    }

    public static synchronized void init(Context cxt) {
        if (mPreferenceManager == null) {
            mPreferenceManager = new PreferenceManager(cxt);
        }
    }

    public static synchronized PreferenceManager getInstance() {
        if (mPreferenceManager == null) {
            throw new RuntimeException("please init first!");
        }
        return mPreferenceManager;
    }

    public void put(String key, String value) {
        editor.putString(key, value);
        editor.apply();
    }

    public String getString(String key) {
        return mSharedPreferences.getString(key, "");
    }

    public void put(String key, int value) {
        editor.putInt(key, value);
        editor.apply();
    }

    public int getInt(String key) {
        return mSharedPreferences.getInt(key, 0);
    }

    public void put(String key, boolean value) {
        editor.putBoolean(key, value);
        editor.apply();
    }

    public boolean getBoolean(String key) {
        return mSharedPreferences.getBoolean(key, false);
    }

    public void put(String key, float value) {
        editor.putFloat(key, value);
        editor.apply();
    }

    public float getFloat(String key) {
        return mSharedPreferences.getFloat(key, 0.0f);
    }

    public void put(String key, long value) {
        editor.putLong(key, value);
        editor.apply();
    }

    public long getLong(String key) {
        return mSharedPreferences.getLong(key, 0L);
    }

    public void put(String key, Set<String> value) {
        editor.putStringSet(key, value);
        editor.apply();
    }

    public void remove(String key) {
        editor.remove(key);
        editor.apply();
    }
}

