/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.utils.schedulers;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.vss.utils.schedulers.BaseSchedulerProvider;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

public class SchedulerProvider
implements BaseSchedulerProvider {
    @Nullable
    private static SchedulerProvider INSTANCE;

    private SchedulerProvider() {
    }

    public static synchronized SchedulerProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SchedulerProvider();
        }
        return INSTANCE;
    }

    @Override
    @NonNull
    public Scheduler computation() {
        return Schedulers.computation();
    }

    @Override
    @NonNull
    public Scheduler io() {
        return Schedulers.io();
    }

    @Override
    @NonNull
    public Scheduler ui() {
        return AndroidSchedulers.mainThread();
    }

    @Override
    @NonNull
    public <T> ObservableTransformer<T, T> applySchedulers() {
        return new ObservableTransformer<T, T>(){

            public ObservableSource<T> apply(Observable<T> observable) {
                return observable.subscribeOn(SchedulerProvider.this.io()).observeOn(SchedulerProvider.this.ui());
            }
        };
    }
}

