/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.utils.rxutils;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.service.hostmanage.HostManageManager;
import com.vhall.appui.baselib.service.language.LanguageManager;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.ActivityCollector;
import com.vhall.appui.baselib.vss.data.ResponseJe;
import com.vhall.appui.baselib.vss.utils.exception.ApiException;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Function;

public class ResponseTransformer {
    public static <T> ObservableTransformer<ResponseJe<T>, T> handleResult() {
        return new ObservableTransformer<ResponseJe<T>, T>(){

            public ObservableSource<T> apply(Observable<ResponseJe<T>> upstream) {
                return upstream.flatMap(new ResponseFunction());
            }
        };
    }

    private static class ResponseFunction<T>
    implements Function<ResponseJe<T>, ObservableSource<T>> {
        private ResponseFunction() {
        }

        public ObservableSource<T> apply(ResponseJe<T> tResponse) {
            int code = tResponse.getCode();
            String message = tResponse.getMsg();
            if (code == 30002) {
                ActivityCollector.finishAll();
                AccountManager.getInstance().logOut(null);
                if (HostManageManager.getInstance().isLoaded()) {
                    HostManageManager.getInstance().startLogin((Context)M.context, new Bundle());
                }
                AccountManager.getInstance().startLogin((Context)M.context, null);
            }
            if (code == 200) {
                return Observable.just(tResponse.getData());
            }
            if (!TextUtils.isEmpty((CharSequence)tResponse.getKey()) && !TextUtils.isEmpty((CharSequence)LanguageManager.getStringId(tResponse.getKey()))) {
                return Observable.error((Throwable)new ApiException(code, LanguageManager.getStringId(tResponse.getKey()), LanguageManager.getStringId(tResponse.getKey())));
            }
            return Observable.error((Throwable)new ApiException(code, message, message));
        }
    }
}

