/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.utils.rxutils;

import android.text.TextUtils;
import android.util.Log;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.VssSdk;
import com.vhall.appui.baselib.vss.api.VssApiConstant;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.utils.exception.ApiException;
import com.vhall.appui.baselib.vss.utils.exception.CustomException;
import com.vhall.appui.baselib.vss.utils.rxutils.IPresenter;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.HashMap;

public class BaseVhallVssHttp
implements IPresenter {
    protected CompositeDisposable mCompositeSubscription;
    public static String vssToken = "";
    protected static String roomId = "";
    protected static ResponseRoomInfo roomInfo = new ResponseRoomInfo();

    public String createVssUrl(String api) {
        if (api.contains("http")) {
            return api;
        }
        return String.format("%s/%s", VssApiConstant.API_HOST, api);
    }

    protected void addSubscribe(Disposable disposable) {
        if (this.mCompositeSubscription == null) {
            this.mCompositeSubscription = new CompositeDisposable();
        }
        this.mCompositeSubscription.add(disposable);
    }

    @Override
    public void subscribe() {
    }

    @Override
    public void unSubscribe() {
        if (this.mCompositeSubscription != null && !this.mCompositeSubscription.isDisposed()) {
            this.mCompositeSubscription.dispose();
        }
    }

    public HashMap<String, String> getDefaultParam(String vssToken, String roomId, int size) {
        HashMap<String, String> param = new HashMap<String, String>(size + 3);
        if (!TextUtils.isEmpty((CharSequence)vssToken)) {
            param.put("vss_token", vssToken);
        }
        if (!TextUtils.isEmpty((CharSequence)roomId)) {
            param.put("room_id", roomId);
        }
        param.put("app_id", VssSdk.getInstance().getAppId());
        param.put("from", "android");
        return param;
    }

    public HashMap<String, String> getVssTokenAndIdParam(String vssToken, String roomId, int size) {
        HashMap<String, String> param = new HashMap<String, String>(size + 3);
        if (!TextUtils.isEmpty((CharSequence)vssToken)) {
            param.put("vss_token", vssToken);
        }
        if (!TextUtils.isEmpty((CharSequence)roomId)) {
            param.put("room_id", roomId);
        }
        return param;
    }

    public HashMap<String, Object> getObjectDefaultParam(String vssToken, String roomId, int size) {
        HashMap<String, Object> param = new HashMap<String, Object>(size);
        if (!TextUtils.isEmpty((CharSequence)vssToken)) {
            param.put("vss_token", vssToken);
        }
        if (!TextUtils.isEmpty((CharSequence)roomId)) {
            param.put("room_id", roomId);
        }
        return param;
    }

    public void dealError(Throwable e, CallBack callback, String tag) {
        String msg;
        if (callback == null) {
            return;
        }
        if (e instanceof ApiException) {
            ApiException exception = CustomException.handleException(-1, e);
            if (TextUtils.isEmpty((CharSequence)exception.getDisplayMessage())) {
                callback.onError(exception.getCode(), exception.getMessage());
                msg = exception.getMessage();
            } else {
                callback.onError(exception.getCode(), exception.getDisplayMessage());
                msg = exception.getDisplayMessage();
            }
        } else {
            callback.onError(-1, e.getMessage());
            msg = e.getMessage();
        }
        Log.e((String)tag, (String)msg);
    }
}

