/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.utils.exception;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.vss.utils.exception.CustomException;

public class ApiException
extends Throwable {
    private int code;
    private String displayMessage;
    public static final int ERROR_CODE_LOGIN = 401;

    public ApiException(int code, String displayMessage) {
        super(displayMessage);
        this.code = code;
        this.displayMessage = displayMessage;
    }

    public ApiException(int code, String message, String displayMessage) {
        super(message);
        this.code = code;
        this.displayMessage = displayMessage;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getDisplayMessage() {
        return this.displayMessage;
    }

    public void setDisplayMessage(String displayMessage) {
        this.displayMessage = displayMessage;
    }

    public static String dealError(Throwable e) {
        String msg;
        if (!InternalUtils.isNetworkConnected((Context)M.context)) {
            return M.getString(R.string.base_net_work_error_please_retry);
        }
        if (e instanceof ApiException) {
            ApiException exception = CustomException.handleException(((ApiException)e).getCode(), e);
            msg = TextUtils.isEmpty((CharSequence)exception.getDisplayMessage()) ? exception.getMessage() : exception.getDisplayMessage();
            if (exception.getCode() == 401) {
                AccountManager.getInstance().logOut(new Bundle());
            }
        } else {
            msg = e.getMessage();
        }
        return msg;
    }
}

