/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.service;

import com.vhall.appui.baselib.service.chat.processor.IChatProcessor;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.vss.data.EnumRoleName;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public interface IMessage {
    public static final int CommonMsg = 0;
    public static final int AtMsg = 1;
    public static final int ReplayMsg = 2;
    public static final int qa = 3;

    default public String getUserId() {
        return null;
    }

    default public String getNickname() {
        return null;
    }

    default public String getText_content() {
        return null;
    }

    default public String getOriginText() {
        return null;
    }

    default public List<String> getOriginImage_urls() {
        return null;
    }

    default public String getRoleName() {
        return null;
    }

    default public int getMsgType() {
        return 0;
    }

    default public String getOperateNickName() {
        return null;
    }

    default public String getRoleNameText() {
        return null;
    }

    default public String getMsgId() {
        return null;
    }

    default public String getDateTime() {
        return null;
    }

    default public String getAvatar() {
        return null;
    }

    default public VssMessageChatData.JumpMsgBean getJumpMsgBean() {
        return null;
    }

    default public List<String> getImage_urls() {
        return new ArrayList<String>();
    }

    default public IChatProcessor getChatProcessor() {
        return null;
    }

    default public void setChatProcessor(IChatProcessor processor) {
    }

    public static class SimpleMessage
    implements IMessage {
        private String usrId = AccountManager.getInstance().getUserId();
        private String nickName = AccountManager.getInstance().getNickName();
        private String textContent;
        private String avatar;
        private String originText;
        private List<String> images = new ArrayList<String>();
        private String roleName = VssRoomManager.getInstance().getRoomInfo().getRole_name();
        private int msgType = 0;
        private String roleNameText = EnumRoleName.getRole(VssRoomManager.getInstance().getRoomInfo().getRole_name()).getName();
        private String dateTime = InternalUtils.getDateCurrentStr();
        private String msgId = UUID.randomUUID().toString();
        private IChatProcessor mProcessor;

        public SimpleMessage(String usrId, String nickName, String avatar, String textContent, String originText, String roleName, int msgType, String roleNameText, String dateTime, String msgId, List<String> images) {
            this.usrId = usrId;
            this.nickName = nickName;
            this.textContent = textContent;
            this.originText = originText;
            this.roleName = roleName;
            this.msgType = msgType;
            this.roleNameText = roleNameText;
            this.dateTime = dateTime;
            this.msgId = msgId;
            this.avatar = avatar;
            this.images = images;
        }

        public SimpleMessage(String textContent) {
            this.textContent = textContent;
            this.originText = textContent;
        }

        @Override
        public String getUserId() {
            return this.usrId;
        }

        @Override
        public String getNickname() {
            return this.nickName;
        }

        @Override
        public String getText_content() {
            return this.textContent;
        }

        @Override
        public String getOriginText() {
            return this.originText;
        }

        @Override
        public List<String> getOriginImage_urls() {
            return new ArrayList<String>();
        }

        @Override
        public String getRoleName() {
            return this.roleName;
        }

        @Override
        public int getMsgType() {
            return this.msgType;
        }

        @Override
        public String getOperateNickName() {
            return null;
        }

        @Override
        public String getRoleNameText() {
            return this.roleNameText;
        }

        @Override
        public String getMsgId() {
            return this.msgId;
        }

        @Override
        public String getDateTime() {
            return this.dateTime;
        }

        @Override
        public String getAvatar() {
            return this.avatar;
        }

        @Override
        public VssMessageChatData.JumpMsgBean getJumpMsgBean() {
            return null;
        }

        @Override
        public List<String> getImage_urls() {
            return this.images;
        }

        @Override
        public IChatProcessor getChatProcessor() {
            return this.mProcessor;
        }

        @Override
        public void setChatProcessor(IChatProcessor processor) {
            this.mProcessor = processor;
        }
    }
}

