/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.net;

import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.ResponseJe;
import com.vhall.appui.baselib.vss.utils.exception.ApiException;
import com.vhall.appui.baselib.vss.utils.exception.CustomException;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;

public class VssNetCallback<T>
implements IVHNetCallback {
    private CallBack callback;
    private Class<T> clz;

    public VssNetCallback(CallBack callback) {
        this.callback = callback;
    }

    public VssNetCallback(CallBack callback, Class<T> clz) {
        this.callback = callback;
        this.clz = clz;
    }

    public void onFailure(VHNetResponse response, Exception e) {
        if (this.callback != null) {
            ApiException exception = CustomException.handleException(response.getResponseCode(), e);
            this.callback.onError(exception.getCode(), exception.getMessage());
        }
    }

    public void response(VHNetResponse response) {
        if (this.callback != null && response != null) {
            ResponseJe<T> data = new ResponseJe<T>(response.getResult(), this.clz);
            if (data.getCode() != 200) {
                this.callback.onError(data.getCode(), data.getMsg());
                return;
            }
            if (null != this.clz) {
                this.callback.onSuccess(data.getData());
            } else {
                this.callback.onSuccess(response.getResult());
            }
        }
    }
}

