/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.rtc;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.bean.User;
import com.vhall.appui.baselib.net.utils.BaseNetwork;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.api.ApiFactory;
import com.vhall.appui.baselib.vss.api.HttpManager;
import com.vhall.appui.baselib.vss.module.role.VssRoleManager;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.module.rtc.IVssRtcListener;
import com.vhall.appui.baselib.vss.utils.rxutils.BaseVhallVssHttp;
import com.vhall.appui.baselib.vss.utils.rxutils.ResponseTransformer;
import com.vhall.appui.baselib.vss.utils.schedulers.SchedulerProvider;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.ilss.VHInteractive;
import com.vhall.vhallrtc.client.Room;
import com.vhall.vhallrtc.client.Stream;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class VssRtcManager
extends BaseVhallVssHttp {
    private static String TAG = "VssRtcManager";
    private static IVssRtcListener iVssRtcListener;
    private static volatile VssRtcManager instance;
    private static VHInteractive vhallRTC;
    private static Stream localStream;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssRtcManager getInstance(Context context) {
        if (roomInfo == null) {
            Log.e((String)TAG, (String)"room data error");
        }
        if (instance != null) return instance;
        Class<VssRtcManager> clazz = VssRtcManager.class;
        synchronized (VssRtcManager.class) {
            if (instance != null) return instance;
            instance = new VssRtcManager();
            VssRtcManager.instance.context = context;
            vhallRTC = new VHInteractive(context.getApplicationContext(), (Room.RoomDelegate)new VssRoomCallback());
            vhallRTC.setOnMessageListener(new VHInteractive.OnMessageListener(){

                public void onMessage(JSONObject jsonObject) {
                }

                public void onRefreshMemberState() {
                    Log.e((String)TAG, (String)"onRefreshMemberState     ");
                    if (iVssRtcListener != null) {
                        iVssRtcListener.onRefreshMemberState();
                    }
                }

                public void onRefreshMembers(JSONObject jsonObject) {
                    Log.e((String)TAG, (String)("onRefreshMembers     " + jsonObject));
                    if (iVssRtcListener != null) {
                        iVssRtcListener.onRefreshMembers(jsonObject);
                    }
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static VHInteractive getVhallRTC() {
        return vhallRTC;
    }

    private Stream initLocalStream(JSONObject option, String attributes) {
        if (localStream != null) {
            localStream.stopStats();
            localStream.dispose();
            localStream = null;
        }
        if (option == null) {
            option = new JSONObject();
            try {
                if ("1".equals(roomInfo.getRole_name())) {
                    option.put("minBitrateKbps", 400);
                    option.put("currentBitrateKbps", 700);
                    option.put("maxBitrateKbps", 1000);
                    option.put("frameResolutionType", Stream.VhallFrameResolutionValue.VhallFrameResolution640x480.getValue());
                } else {
                    option.put("frameResolutionType", Stream.VhallFrameResolutionValue.VhallFrameResolution480x360.getValue());
                }
                option.put("streamType", Stream.VhallStreamType.VhallStreamTypeAudioAndVideo.getValue());
                option.put("numSpatialLayers", 2);
            }
            catch (Exception e) {
                e.printStackTrace();
                return localStream;
            }
        }
        localStream = vhallRTC.createLocalStream(option, attributes);
        if (TextUtils.isEmpty((CharSequence)VssRtcManager.localStream.userId)) {
            VssRtcManager.localStream.userId = AccountManager.getInstance().getUserId();
        }
        return localStream;
    }

    public void publish() {
        if (!VssRoleManager.getInstance().canPushStream()) {
            Log.e((String)TAG, (String)"\u6ca1\u6709\u63a8\u6d41\u6743\u9650");
            return;
        }
        if (vhallRTC == null) {
            return;
        }
        vhallRTC.publish();
    }

    public void unPublish() {
        if (vhallRTC == null || localStream == null) {
            return;
        }
        vhallRTC.unpublish();
    }

    public static void leaveRoom() {
        VssRtcManager.leaveRoom(true);
    }

    public static void leaveRoom(boolean noSpeak) {
        VssRtcManager.leaveRoom(noSpeak, true);
    }

    public static void leaveRoom(boolean noSpeak, boolean isLiving) {
        if (vhallRTC == null) {
            return;
        }
        if (localStream != null) {
            localStream.stopStats();
        }
        if (noSpeak && instance != null) {
            instance.noSpeak(isLiving);
        }
        vhallRTC.setListener(null);
        vhallRTC.setOnConnectChangedListener(null);
        vhallRTC.setOnMessageListener(null);
        try {
            vhallRTC.release();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage());
            if (instance != null) {
                instance = null;
            }
            if (localStream != null) {
                localStream.dispose();
                localStream = null;
            }
            vhallRTC = null;
        }
        if (instance != null) {
            instance = null;
        }
        if (localStream != null) {
            localStream.dispose();
            localStream = null;
        }
        vhallRTC = null;
    }

    public Stream createLocalStream(JSONObject option) {
        return this.initLocalStream(option, null);
    }

    public Stream createLocalStream(JSONObject option, String attributes) {
        if (localStream == null) {
            Log.e((String)TAG, (String)"localStream is empty");
            return this.initLocalStream(option, attributes);
        }
        return localStream;
    }

    public static Stream getLocalStream() {
        if (localStream == null) {
            Log.e((String)TAG, (String)"localStream is empty");
        }
        return localStream;
    }

    public static void setLocalStream(Stream stream) {
        localStream = stream;
    }

    public void setRtvListener(IVssRtcListener Listener) {
        if (Listener != null) {
            iVssRtcListener = Listener;
        } else {
            Log.e((String)TAG, (String)"Listener empty");
        }
    }

    public void setDeviceStatus(String device, String status, CallBack callBack) {
        this.setDeviceStatus(device, status, "", callBack);
    }

    public void setDeviceStatus(String device, String status, String userId, final CallBack callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("device", device);
        params.put("status", status);
        if (TextUtils.isEmpty((CharSequence)userId)) {
            params.put("receive_account_id", roomInfo.getThird_party_user_id());
            if (!VssRoleManager.getInstance().canOpenCameraVoice()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u5f00\u5173\u81ea\u5df1\u7684\u97f3\u89c6\u9891\u6743\u9650");
                }
                Log.e((String)TAG, (String)"\u6ca1\u6709\u5f00\u5173\u81ea\u5df1\u7684\u97f3\u89c6\u9891\u6743\u9650");
                return;
            }
        } else {
            if (!VssRoleManager.getInstance().canChangeOtherVoiceCamera()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u5f00\u5173\u522b\u4eba\u7684\u97f3\u89c6\u9891\u6743\u9650");
                }
                Log.e((String)TAG, (String)"\u6ca1\u6709\u5f00\u5173\u522b\u4eba\u7684\u97f3\u89c6\u9891\u6743\u9650");
                return;
            }
            params.put("receive_account_id", userId);
        }
        CommonManagerNetWrapper.setDeviceStatus(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    public void setStream(String layout2, String definition, final CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("layout", layout2);
        params.put("definition", definition);
        this.addSubscribe(ApiFactory.getApiSingleton().setStream(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssRtcManager.this.dealError(e, callBack, TAG);
            }
        }));
    }

    public void apply(final CallBack callBack) {
        if (!VssRoleManager.getInstance().canApplySpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u7533\u8bf7\u4e0a\u9ea6\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u7533\u8bf7\u4e0a\u9ea6\u6743\u9650");
            return;
        }
        HashMap<String, String> bodyParams = this.getDefaultParam(vssToken, roomId, 2);
        this.addSubscribe(ApiFactory.getApiSingleton().apply(HttpManager.getRequestBody(bodyParams)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(s);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssRtcManager.this.dealError(e, callBack, TAG);
            }
        }));
    }

    public void rejectInvite(final CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("account_id", roomInfo.getThird_party_user_id());
        params.put("receive_account_id", String.valueOf(roomInfo.getAccount_id()));
        CommonManagerNetWrapper.rejectInvite(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void cancelApply(final CallBack callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("account_id", roomInfo.getThird_party_user_id());
        CommonManagerNetWrapper.cancelApply(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void agreeInvite(final CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u64cd\u63a7\u522b\u4eba\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_account_id", AccountManager.getInstance().getUserId());
        CommonManagerNetWrapper.agreeInvite(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void noSpeak(boolean isLiving) {
        if (vhallRTC != null) {
            if (localStream != null) {
                vhallRTC.unpublish();
            }
            if ("1".equals(roomInfo.getRole_name())) {
                if (isLiving) {
                    vhallRTC.broadcastRoom(2, null);
                    VssRoomManager.getInstance().roomEndLive(null);
                }
            } else {
                this.noSpeak(null, null);
            }
        }
    }

    public void noSpeak(String id2, final CallBack callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        if (TextUtils.isEmpty((CharSequence)id2)) {
            if (!VssRoleManager.getInstance().canOnSpeak()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u4e0b\u9ea6\u63a7\u5236\u6743\u9650");
                }
                Log.e((String)TAG, (String)"\u6ca1\u6709\u4e0b\u9ea6\u63a7\u5236\u6743\u9650");
                return;
            }
            params.put("receive_account_id", roomInfo.getThird_party_user_id());
        } else {
            if (!VssRoleManager.getInstance().canOperateOtherOnSpeak()) {
                if (callBack != null) {
                    callBack.onError(1001, "\u6ca1\u6709\u4e0b\u9ea6\u4ed6\u4eba\u63a7\u5236\u6743\u9650");
                }
                Log.e((String)TAG, (String)"\u6ca1\u6709\u4e0b\u9ea6\u4ed6\u4eba\u63a7\u5236\u6743\u9650");
                return;
            }
            params.put("receive_account_id", id2);
        }
        CommonManagerNetWrapper.noSpeak(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void speak(JSONObject option, String attributes, CallBack callBack) {
        this.speak(true, option, callBack);
    }

    public void speak(JSONObject option, CallBack callBack) {
        this.speak(true, option, callBack);
    }

    public void speak(boolean setLocalStream, JSONObject option, CallBack callBack) {
        this.speak(setLocalStream, option, null, callBack);
    }

    public void speak(final boolean setLocalStream, JSONObject option, String attributes, final CallBack callBack) {
        if (vhallRTC == null || roomInfo == null) {
            Log.e((String)TAG, (String)" speak data error");
            callBack.onError(-1, " speak data error");
            return;
        }
        if (option == null) {
            option = new JSONObject();
            try {
                if ("1".equals(roomInfo.getRole_name())) {
                    option.put("minBitrateKbps", 400);
                    option.put("currentBitrateKbps", 1200);
                    option.put("maxBitrateKbps", 1500);
                    option.put("frameResolutionType", Stream.VhallFrameResolutionValue.VhallFrameResolution640x480.getValue());
                } else {
                    option.put("frameResolutionType", Stream.VhallFrameResolutionValue.VhallFrameResolution480x360.getValue());
                }
                option.put("streamType", Stream.VhallStreamType.VhallStreamTypeAudioAndVideo.getValue());
                option.put("numSpatialLayers", 2);
            }
            catch (JSONException e) {
                e.printStackTrace();
                callBack.onError(-1, " option data error");
                return;
            }
        }
        final JSONObject finalOption = option;
        vhallRTC.init(roomInfo.getInav_id(), roomInfo.getPaas_access_token(), roomId, new VHInteractive.InitCallback(){

            public void onSuccess() {
                if (roomInfo == null) {
                    return;
                }
                if (setLocalStream) {
                    JSONObject objAttributes = new JSONObject();
                    try {
                        objAttributes.put("nick_name", (Object)(User.getFromLocal((Context)((VssRtcManager)VssRtcManager.this).context).nick_name + ""));
                        objAttributes.put("account_id", (Object)roomInfo.getThird_party_user_id());
                        objAttributes.put("role_name", (Object)roomInfo.getRole_name());
                        objAttributes.put("video", (Object)"1");
                        objAttributes.put("audio", (Object)"1");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    VssRtcManager.this.initLocalStream(finalOption, objAttributes.toString());
                }
                JSONObject obj = new JSONObject();
                try {
                    obj.put("join_uid", (Object)roomInfo.getThird_party_user_id());
                    obj.put("join_uname", (Object)roomInfo.getThird_party_user_id());
                    obj.put("join_role", (Object)roomInfo.getRole_name());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                vhallRTC.enterRoom(obj.toString());
                callBack.onSuccess("success");
            }

            public void onFailure(int i, String s) {
                Log.e((String)TAG, (String)s);
                callBack.onError(i, s);
            }
        });
    }

    public void unableSpeak() {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("from", "android");
        String token = TextUtils.isEmpty((CharSequence)AccountManager.getInstance().getToken()) ? "" : AccountManager.getInstance().getToken();
        CommonManagerNetWrapper.unableSpeak(vssToken, token, params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                Log.e((String)"zrq", (String)result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                Log.e((String)"zrq", (String)msg);
            }
        });
    }

    public void agreeApply(String userId, final CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u540c\u610f\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u540c\u610f\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_account_id", userId);
        CommonManagerNetWrapper.agreeApply(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    public void setKicked(String receiveJoinId, String status, final CallBack callBack) {
        if (!VssRoleManager.getInstance().canChatKickOut()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8e22\u51fa\u6216\u53d6\u6d88\u8e22\u51fa\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u8e22\u51fa\u6216\u53d6\u6d88\u8e22\u51fa\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        params.put("status", status);
        CommonManagerNetWrapper.setKicked(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void setMainScreenV2(String receiveJoinId, String receive_account_id, final CallBack callBack) {
        HashMap<String, String> bodyParams = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        bodyParams.put("receive_join_id", receiveJoinId);
        bodyParams.put("receive_account_id", receive_account_id);
        CommonManagerNetWrapper.setMainScreen(bodyParams, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void setDocPermission(String receiveJoinId, String joinId, final CallBack callBack) {
        if (!VssRoleManager.getInstance().canDocwhiteBoard()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8bbe\u7f6e\u6587\u6863\u767d\u677f\u6743\u9650\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u8bbe\u7f6e\u6587\u6863\u767d\u677f\u6743\u9650\u6743\u9650");
            return;
        }
        HashMap<String, String> bodyParams = this.getDefaultParam(vssToken, roomId, 4);
        bodyParams.put("receive_join_id", receiveJoinId);
        bodyParams.put("join_id", joinId);
        this.addSubscribe(ApiFactory.getApiSingleton().setDocPermission(HttpManager.getRequestBody(bodyParams)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssRtcManager.this.dealError(e, callBack, TAG);
            }
        }));
    }

    public void rejectApply(String userId, final CallBack callBack) {
        if (!VssRoleManager.getInstance().canOperateInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u62d2\u7edd\u7528\u6237\u4e0a\u9ea6\u7533\u8bf7\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u62d2\u7edd\u7528\u6237\u4e0a\u9ea6\u7533\u8bf7\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_account_id", userId);
        CommonManagerNetWrapper.rejectApply(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    public void setHandsUp(String status, final CallBack callBack) {
        if (!VssRoleManager.getInstance().canRaiseHandSwitch()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8bbe\u7f6e\u4e3e\u624b\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u8bbe\u7f6e\u4e3e\u624b\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("status", status);
        CommonManagerNetWrapper.setHandUp(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    public void breakSpeak(String account_id, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", account_id);
        String token = TextUtils.isEmpty((CharSequence)AccountManager.getInstance().getToken()) ? "" : AccountManager.getInstance().getToken();
        CommonManagerNetWrapper.breakSpeak(vssToken, token, params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                VHToast.showShortToast(R.string.base_break_speak_success);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(R.string.base_break_speak_error);
            }
        });
    }

    public void invite(String receiveJoinId, final CallBack callBack) {
        if (!VssRoleManager.getInstance().canInviteSpeak()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u9080\u8bf7\u7528\u6237\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u9080\u8bf7\u7528\u6237\u4e0a\u9ea6\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        CommonManagerNetWrapper.invite(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void setBanned(String receiveJoinId, String status, final CallBack callBack) {
        if (!VssRoleManager.getInstance().canChatBanned()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u7981\u8a00\u6216\u53d6\u6d88\u7981\u8a00\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)TAG, (String)"\u6ca1\u6709\u7981\u8a00\u6216\u53d6\u6d88\u7981\u8a00\u63a7\u5236\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        params.put("status", status);
        CommonManagerNetWrapper.setBanned(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(null);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void broadCast(JSONObject jsonObject, final CallBack callback) {
        JSONObject user;
        if (jsonObject != null && (user = jsonObject.optJSONObject("user")) != null) {
            String join_role;
            String attributes = user.optString("attributes");
            JSONObject attributesObject = null;
            try {
                attributesObject = new JSONObject(attributes);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (attributesObject != null && !TextUtils.isEmpty((CharSequence)(join_role = attributesObject.optString("join_role"))) && join_role.equals(VssRoleManager.getInstance().getRoleType())) {
                vhallRTC.broadcastRoom(1, new Callback(){

                    public void onFailure(Call callbackcall, IOException e) {
                        if (callback == null) {
                            return;
                        }
                        callback.onError(-1, e.getMessage());
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        VssRoomManager.getInstance().roomStartLive(new CallBack<String>(){

                            @Override
                            public void onSuccess(String result) {
                                if (callback == null) {
                                    return;
                                }
                                callback.onSuccess(null);
                            }

                            @Override
                            public void onError(int eventCode, String msg) {
                                if (callback == null) {
                                    return;
                                }
                                callback.onError(eventCode, msg);
                            }
                        });
                    }
                });
            }
        }
    }

    public static class VssRoomCallback
    implements Room.RoomDelegate {
        void speak(final CallBack callBack, final String streamID) {
            if (instance == null) {
                return;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("vss_token", BaseVhallVssHttp.vssToken);
            hashMap.put("room_id", roomId);
            VHNetApi.getNetApi().doPost(BaseNetwork.getBaseRequest(hashMap, "/api/inav/speak"), new CoreNetCallback<String>(new CallBack<String>(){

                @Override
                public void onSuccess(String result) {
                    if (callBack == null) {
                        return;
                    }
                    callBack.onSuccess("success");
                }

                @Override
                public void onError(int eventCode, String msg) {
                    if (instance == null) {
                        return;
                    }
                    if (iVssRtcListener != null) {
                        iVssRtcListener.onSpeakError(streamID);
                    }
                }
            }, String.class));
        }

        public void onDidConnect(Room room, JSONObject jsonObject) {
            Log.e((String)TAG, (String)"onDidConnect");
            JSONObject user = jsonObject.optJSONObject("user");
            JSONObject attributes = null;
            if (user != null) {
                try {
                    attributes = new JSONObject(user.optString("attributes"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            String joinRole = attributes.optString("join_role");
            for (Stream stream : room.getRemoteStreams()) {
                room.subscribe(stream);
            }
            if (vhallRTC != null && vhallRTC.isInviteAvailable() || "1".equals(joinRole)) {
                vhallRTC.publish();
            }
        }

        public void onDidError(Room room, Room.VHRoomErrorStatus vhRoomErrorStatus, String s) {
            Log.i((String)TAG, (String)"onDidError");
            for (Stream stream : room.getRemoteStreams()) {
                if (iVssRtcListener == null) {
                    return;
                }
                iVssRtcListener.removeStream(stream);
            }
            iVssRtcListener.onDidError(room, vhRoomErrorStatus, s);
        }

        public void onDidPublishStream(Room room, Stream stream) {
            Log.e((String)TAG, (String)"onDidPublishStream");
            if ("".equals(roomInfo.getRole_name())) {
                return;
            }
            this.speak(null, stream.userId);
        }

        public void onDidUnPublishStream(Room room, Stream stream) {
            Log.e((String)TAG, (String)"onDidUnPublishStream");
            if (iVssRtcListener == null) {
                return;
            }
        }

        public void onDidSubscribeStream(Room room, Stream stream) {
            Log.e((String)TAG, (String)"onDidSubscribeStream");
            if (iVssRtcListener == null) {
                return;
            }
            iVssRtcListener.addStream(stream);
        }

        public void onDidUnSubscribeStream(Room room, Stream stream) {
            Log.i((String)TAG, (String)"onDidUnSubscribeStream");
            if (iVssRtcListener == null) {
                return;
            }
            iVssRtcListener.removeStream(stream);
        }

        public void onDidChangeStatus(Room room, Room.VHRoomStatus vhRoomStatus) {
            if (iVssRtcListener == null) {
                return;
            }
            switch (vhRoomStatus) {
                case VHRoomStatusDisconnected: {
                    iVssRtcListener.roomStatusMessageChange(room, 10005);
                    break;
                }
                case VHRoomStatusError: {
                    Log.e((String)TAG, (String)"VHRoomStatusError");
                    iVssRtcListener.roomStatusMessageChange(room, 10006);
                    break;
                }
                case VHRoomStatusReady: {
                    Log.e((String)TAG, (String)"VHRoomStatusReady");
                    iVssRtcListener.roomStatusMessageChange(room, 10007);
                    break;
                }
                case VHRoomStatusConnected: {
                    Log.e((String)TAG, (String)"VHRoomStatusConnected");
                    iVssRtcListener.roomStatusMessageChange(room, 10008);
                    break;
                }
            }
        }

        public void onDidAddStream(Room room, Stream stream) {
            Log.i((String)TAG, (String)"onDidAddStream");
            room.subscribe(stream);
        }

        public void onDidRemoveStream(Room room, Stream stream) {
            if (iVssRtcListener == null) {
                return;
            }
            iVssRtcListener.removeStream(stream);
        }

        public void onDidUpdateOfStream(Stream stream, JSONObject jsonObject) {
            Log.i((String)TAG, (String)"onDidUpdateOfStream");
            if (iVssRtcListener == null) {
                return;
            }
            iVssRtcListener.updateStream(stream);
        }

        public void onReconnect(int i, int i1) {
            Log.e((String)TAG, (String)("onReconnect    " + i + " i1=" + i1));
            if (iVssRtcListener == null) {
                return;
            }
            iVssRtcListener.onReconnect(i, i1);
        }

        public void onStreamMixed(JSONObject jsonObject) {
            if (iVssRtcListener == null) {
                return;
            }
            iVssRtcListener.onStreamMixed(jsonObject);
        }
    }
}

