/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.room.interceptor;

import android.text.TextUtils;
import com.vhall.appui.baselib.vss.data.ResponseImMessageInfo;
import com.vhall.appui.baselib.vss.module.room.bean.InteractiveUserBean;
import com.vhall.appui.baselib.vss.module.room.interceptor.IInterceptor;
import java.util.Map;
import org.json.JSONObject;

public class InteractiveInterceptor
implements IInterceptor {
    Map<String, InteractiveUserBean> mInteractiveListResponseBeanMap;

    public InteractiveInterceptor(Map<String, InteractiveUserBean> mInteractiveListResponseBeanMap) {
        this.mInteractiveListResponseBeanMap = mInteractiveListResponseBeanMap;
    }

    @Override
    public void onMessage(String type, ResponseImMessageInfo responseImMessageInfo) {
        switch (type) {
            case "vrtc_connect_success": {
                try {
                    JSONObject dataJson = new JSONObject(responseImMessageInfo.getData());
                    String userId = dataJson.optString("room_join_id");
                    String nickName = dataJson.optString("nick_name");
                    boolean audio = TextUtils.equals((CharSequence)dataJson.optString("vrtc_audio_status"), (CharSequence)"on");
                    boolean video = TextUtils.equals((CharSequence)dataJson.optString("vrtc_video_status"), (CharSequence)"on");
                    this.mInteractiveListResponseBeanMap.put(userId, new InteractiveUserBean(userId, audio, video, nickName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "vrtc_mute": {
                try {
                    JSONObject dataJson = new JSONObject(responseImMessageInfo.getData());
                    String userId = dataJson.optString("room_join_id");
                    if (!this.mInteractiveListResponseBeanMap.containsKey(userId)) break;
                    this.mInteractiveListResponseBeanMap.get((Object)userId).audio = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "vrtc_disconnect_success": {
                try {
                    String userId = new JSONObject(responseImMessageInfo.getData()).optString("room_join_id");
                    this.mInteractiveListResponseBeanMap.remove(userId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "vrtc_mute_cancel": {
                try {
                    JSONObject dataJson = new JSONObject(responseImMessageInfo.getData());
                    String userId = dataJson.optString("room_join_id");
                    if (!this.mInteractiveListResponseBeanMap.containsKey(userId)) break;
                    this.mInteractiveListResponseBeanMap.get((Object)userId).audio = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "vrtc_frames_forbid": {
                try {
                    JSONObject dataJson = new JSONObject(responseImMessageInfo.getData());
                    String userId = dataJson.optString("room_join_id");
                    if (!this.mInteractiveListResponseBeanMap.containsKey(userId)) break;
                    this.mInteractiveListResponseBeanMap.get((Object)userId).video = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "vrtc_frames_display": {
                try {
                    JSONObject dataJson = new JSONObject(responseImMessageInfo.getData());
                    String userId = dataJson.optString("room_join_id");
                    if (!this.mInteractiveListResponseBeanMap.containsKey(userId)) break;
                    this.mInteractiveListResponseBeanMap.get((Object)userId).video = true;
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

