/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.room;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.ContextCompat;
import com.alibaba.fastjson.JSON;
import com.vhall.appui.baselib.bean.SpeakListBean;
import com.vhall.appui.baselib.net.bean.IBaseRequestBean;
import com.vhall.appui.baselib.net.utils.BaseNetwork;
import com.vhall.appui.baselib.net.utils.CoreNetCallback;
import com.vhall.appui.baselib.network.CommonManagerNetWrapper;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.service.sensitivewords.IFilterSensitiveWordsResultListener;
import com.vhall.appui.baselib.service.sensitivewords.SensitiveWordsManager;
import com.vhall.appui.baselib.utils.AsyncManager;
import com.vhall.appui.baselib.utils.InternalUtils;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.utils.VhLog;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.SimpleCallback;
import com.vhall.appui.baselib.vss.VssSdk;
import com.vhall.appui.baselib.vss.api.ApiFactory;
import com.vhall.appui.baselib.vss.api.HttpManager;
import com.vhall.appui.baselib.vss.data.EnumRoleName;
import com.vhall.appui.baselib.vss.data.InavGetRoomInfo;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.ResponseAttributes;
import com.vhall.appui.baselib.vss.data.ResponseImMessageInfo;
import com.vhall.appui.baselib.vss.data.ResponsePushInfo;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.data.ResponseScrollingInfo;
import com.vhall.appui.baselib.vss.data.ResponseUserStatus;
import com.vhall.appui.baselib.vss.data.UserInfoData;
import com.vhall.appui.baselib.vss.module.chat.IAuditMessage;
import com.vhall.appui.baselib.vss.module.role.VssRoleManager;
import com.vhall.appui.baselib.vss.module.room.bean.InteractiveUserBean;
import com.vhall.appui.baselib.vss.module.room.callback.IVssCallBackListener;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import com.vhall.appui.baselib.vss.module.room.interceptor.IInterceptor;
import com.vhall.appui.baselib.vss.module.room.interceptor.InteractiveInterceptor;
import com.vhall.appui.baselib.vss.net.VHJSON;
import com.vhall.appui.baselib.vss.net.VssNetCallback;
import com.vhall.appui.baselib.vss.utils.rxutils.BaseVhallVssHttp;
import com.vhall.appui.baselib.vss.utils.rxutils.ResponseTransformer;
import com.vhall.appui.baselib.vss.utils.schedulers.SchedulerProvider;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.httpclient.utils.OKHttpUtils;
import com.vhall.ims.VHIM;
import com.vhall.ims.message.IBody;
import com.vhall.ims.message.IVHMessage;
import com.vhall.message.ConnectServer;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.json.JSONObject;

public class VssRoomManager
extends BaseVhallVssHttp {
    private final String TAG = "VssRoomManager";
    private VHIM im;
    private HashMap<String, VHIM> ims = new HashMap();
    private static volatile VssRoomManager instance;
    public static boolean enter;
    private IVssCallBackListener vssCallBackListener;
    private List<IVssMessageListener> messageListenerList = new ArrayList<IVssMessageListener>();
    private String mainScreenId;
    private Map<String, InteractiveUserBean> mInteractiveListResponseBeanMap = new HashMap<String, InteractiveUserBean>();
    private Disposable mDisposable;
    List<IInterceptor> iInterceptors = new ArrayList<IInterceptor>();

    public ResponseRoomInfo getInfo() {
        return roomInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssRoomManager getInstance() {
        if (instance != null) return instance;
        Class<VssRoomManager> clazz = VssRoomManager.class;
        synchronized (VssRoomManager.class) {
            if (instance != null) return instance;
            instance = new VssRoomManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getMainScreenId() {
        return TextUtils.isEmpty((CharSequence)this.mainScreenId) ? roomInfo.getHostId() : this.mainScreenId;
    }

    public void removeMainScreenId(String userId) {
        if (!TextUtils.isEmpty((CharSequence)userId) && TextUtils.equals((CharSequence)userId, (CharSequence)this.mainScreenId)) {
            this.mainScreenId = "";
        }
    }

    public boolean isHostEqualMainScreen() {
        if (TextUtils.isEmpty((CharSequence)this.mainScreenId)) {
            return true;
        }
        return TextUtils.equals((CharSequence)this.mainScreenId, (CharSequence)roomInfo.getHostId());
    }

    private VssRoomManager() {
        this.init();
    }

    private void init() {
        this.iInterceptors.add(new InteractiveInterceptor(this.mInteractiveListResponseBeanMap));
    }

    public void enterRoom(InavGetRoomInfo inavGetRoomInfo, CallBack<ResponseRoomInfo> callBack) {
        if (callBack == null) {
            callBack = new SimpleCallback<ResponseRoomInfo>();
        }
        if (inavGetRoomInfo == null || inavGetRoomInfo.getRoom_info() == null || TextUtils.isEmpty((CharSequence)inavGetRoomInfo.getAccess_token_url())) {
            if (callBack != null) {
                callBack.onError(-1, "access_token_url empty");
            }
            return;
        }
        enter = true;
        roomInfo = ResponseRoomInfo.getResponseRoomInfo(inavGetRoomInfo);
        vssToken = inavGetRoomInfo.getVss_token();
        roomId = inavGetRoomInfo.getRoom_info().room_id;
        OkHttpClient okClient = OKHttpUtils.createOkClient();
        Request request = new Request.Builder().url(inavGetRoomInfo.getAccess_token_url()).addHeader("user-agent", "android common").addHeader("token", AccountManager.getInstance().getToken()).build();
        final CallBack<ResponseRoomInfo> finalCallBack = callBack;
        okClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, final IOException e) {
                if (TextUtils.isEmpty((CharSequence)roomInfo.getPaas_access_token())) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            finalCallBack.onError(-1, e.getMessage());
                        }
                    });
                }
                Log.e((String)"access_token error", (String)e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                try {
                    JSONObject object = new JSONObject(response.body().string());
                    JSONObject data = object.optJSONObject("data");
                    roomInfo.setPaas_access_token(data.optString("access_token"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (roomInfo == null || TextUtils.isEmpty((CharSequence)roomInfo.getPaas_access_token())) {
                    AsyncManager.postUI(new Runnable(){

                        @Override
                        public void run() {
                            finalCallBack.onError(-1, "access_token error");
                        }
                    });
                } else {
                    if (roomInfo == null) {
                        AsyncManager.postUI(new Runnable(){

                            @Override
                            public void run() {
                                finalCallBack.onError(-1, "access_token error");
                            }
                        });
                        return;
                    }
                    UserInfoData userInfo = VHJSON.parseObject(VhallSDK.getInstance().getmUserInfo(), UserInfoData.class);
                    if (userInfo == null) {
                        userInfo = new UserInfoData();
                    }
                    try {
                        userInfo.setThird_party_user_id(roomInfo.getThird_party_user_id() + "");
                        userInfo.setRole_name(roomInfo.getRole_name());
                        userInfo.setDevice_type("4");
                        userInfo.setDevice_status("1");
                        userInfo.setIs_banned(roomInfo.getIs_banned());
                        userInfo.setNickname(AccountManager.getInstance().getNickName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    VssSdk.getInstance().setUserInfo(userInfo);
                    VssRoomManager.this.registerImListener();
                    if (VssRoomManager.isGrantExternal(VssSdk.mContext)) {
                        VssRoomManager.this.setDevice("1", "4");
                    } else {
                        VssRoomManager.this.setDevice("2", "4");
                    }
                    VssRoomManager.this.initBaseData(finalCallBack);
                }
            }
        });
    }

    private void initBaseData(CallBack finalCallBack) {
        this.getUserStatus(finalCallBack);
    }

    private void getUserStatus(final CallBack finalCallBack) {
        CommonManagerNetWrapper.getUserStatus(new IBaseRequestBean(), new CallBack<ResponseUserStatus>(){

            @Override
            public void onSuccess(ResponseUserStatus responseUserStatusResponseJe) {
                try {
                    roomInfo.setIs_banned(responseUserStatusResponseJe.getIs_banned());
                    roomInfo.setIs_kicked(responseUserStatusResponseJe.getIs_kicked());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VssRoomManager.this.getUserAttributes(finalCallBack);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VssRoomManager.this.getUserAttributes(finalCallBack);
            }
        });
    }

    private void getUserAttributes(final CallBack finalCallBack) {
        CommonManagerNetWrapper.getAttributes(new IBaseRequestBean(), new CallBack<ResponseAttributes>(){

            @Override
            public void onSuccess(ResponseAttributes responseAttributesResponseJe) {
                try {
                    roomInfo.setResponseAttributes(responseAttributesResponseJe);
                    String speaker_list = responseAttributesResponseJe.getSpeaker_list();
                    List speakListBeanList = JSON.parseArray((String)speaker_list, SpeakListBean.class);
                    for (int i = 0; i < speakListBeanList.size(); ++i) {
                        SpeakListBean speakListBean = (SpeakListBean)speakListBeanList.get(i);
                        VssRoomManager.this.mInteractiveListResponseBeanMap.put(speakListBean.getAccount_id(), new InteractiveUserBean(speakListBean.getAccount_id(), InternalUtils.convertBoolean(speakListBean.getAudio()), InternalUtils.convertBoolean(speakListBean.getVideo()), speakListBean.getNick_name()));
                        VssRoomManager.this.mainScreenId = responseAttributesResponseJe.getMain_screen();
                        if (EnumRoleName.getRole(speakListBean.getRole_name()) != EnumRoleName.host) continue;
                        roomInfo.setHostNickName(speakListBean.getNick_name());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AsyncManager.postUI(new Runnable(){

                    @Override
                    public void run() {
                        if (finalCallBack != null) {
                            finalCallBack.onSuccess(roomInfo);
                        }
                    }
                });
            }

            @Override
            public void onError(int eventCode, String msg) {
                AsyncManager.postUI(new Runnable(){

                    @Override
                    public void run() {
                        if (finalCallBack != null) {
                            finalCallBack.onSuccess(roomInfo);
                        }
                    }
                });
            }
        });
    }

    private void registerImListener() {
        try {
            if (this.ims.containsKey(roomInfo.getChannel_id())) {
                this.im = this.ims.get(roomInfo.getChannel_id());
            } else {
                this.im = new VHIM(roomInfo.getChannel_id(), roomInfo.getPaas_access_token());
                this.im.setOnMessageListener((VHIM.OnMessageListener)new MsgListenerInternalImpl());
                this.im.setOnConnectChangedListener(new VhallConnectService.OnConnectStateChangedListener(){

                    public void onStateChanged(ConnectServer.State state, int i) {
                        if (VssRoomManager.this.vssCallBackListener != null) {
                            VssRoomManager.this.vssCallBackListener.onStateChanged(state, i);
                        }
                    }
                });
                this.im.join();
                this.ims.put(roomInfo.getChannel_id(), this.im);
            }
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
    }

    public ResponseRoomInfo getRoomInfo() {
        if (enter) {
            return this.getInfo();
        }
        return new ResponseRoomInfo();
    }

    public void roomGetPushInfo(String status, CallBack<ResponsePushInfo> callBack) {
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> bodyParams = this.getVssTokenAndIdParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder().addFormParas(bodyParams).setUrl(this.createVssUrl("room/get-push-info")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponsePushInfo>(callBack, ResponsePushInfo.class));
    }

    public void roomStartLive(CallBack<String> callBack) {
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 2);
        VHNetApi.getNetApi().doPost(BaseNetwork.getBaseRequest(params, "/api/room/start-live"), new CoreNetCallback(callBack));
    }

    public void sendNotice(String content, CallBack callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(null, roomId, 2);
        params.put("content", content);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/send-notice")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void setKicked(String receiveJoinId, String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canChatKickOut()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8e22\u51fa\u6216\u53d6\u6d88\u8e22\u51fa\u6743\u9650");
            }
            Log.e((String)"VssRoomManager", (String)"\u6ca1\u6709\u8e22\u51fa\u6216\u53d6\u6d88\u8e22\u51fa\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        params.put("status", status);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("v2/inav/set-kicked")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void setMainScreen(String receiveJoinId, String joinId, final CallBack callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_join_id", receiveJoinId);
        params.put("join_id", joinId);
        params.put("receive_account_id", AccountManager.getInstance().getUserId());
        CommonManagerNetWrapper.setMainScreen(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                if (callBack == null) {
                    return;
                }
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
                VHToast.showShortToast(msg);
            }
        });
    }

    public void setDocPermission(String receiveJoinId, String joinId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canDocwhiteBoard()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8bbe\u7f6e\u6587\u6863\u767d\u677f\u6743\u9650\u6743\u9650");
            }
            return;
        }
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("receive_join_id", receiveJoinId);
        params.put("join_id", joinId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-doc-permission")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void roomEndLive(CallBack<String> callBack) {
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("vss_token", vssToken);
        hashMap.put("room_id", roomId);
        VHNetApi.getNetApi().doPost(BaseNetwork.getBaseRequest(hashMap, "/api/room/end-live"), new CoreNetCallback(callBack));
    }

    public void roomSwitchDoc(String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canDocSwitch()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u6587\u6863\u5f00\u5173\u63a7\u5236\u6743\u9650");
            }
            Log.e((String)"VssRoomManager", (String)"\u6ca1\u6709\u6587\u6863\u5f00\u5173\u63a7\u5236\u6743\u9650");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            callBack.onError(-1, "NO enter room");
            return;
        }
        HashMap<String, String> bodyParams = this.getVssTokenAndIdParam(vssToken, roomId, 3);
        bodyParams.put("status", status);
        IVHRequest request = new IVHRequest.Builder().addFormParas(bodyParams).setUrl(this.createVssUrl("room/switch-doc")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void setVssCallBackListener(IVssCallBackListener listener) {
        if (this.im != null) {
            this.vssCallBackListener = listener;
        } else {
            Log.e((String)"VssRoomManager", (String)"No enter room");
        }
    }

    public static boolean isGrantExternal(Context context) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") == 0 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.RECORD_AUDIO") == 0;
    }

    public void getScrollingInfo(final CallBack<ResponseScrollingInfo> callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 2);
        ApiFactory.getApiSingleton().getScrollingInfo(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<ResponseScrollingInfo>(){

            public void accept(ResponseScrollingInfo s) {
                if (callBack != null) {
                    callBack.onSuccess(s);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssRoomManager.this.dealError(e, callBack, "VssRoomManager");
            }
        });
    }

    public void getAttributes(CallBack<ResponseAttributes> callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("v2/room/get-attributes")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseAttributes>(callBack, ResponseAttributes.class));
    }

    public void setDevice(String status, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("vss_token", vssToken);
        params.put("room_id", roomId);
        params.put("status", status);
        params.put("type", type);
        params.put("receive_account_id", AccountManager.getInstance().getUserId());
    }

    public void sendMsg(String msg, String type, CallBack callBack) {
        this.sendMsg(msg, type, callBack, null);
    }

    public void sendMsg(String msg, final String type, final CallBack callBack, final IAuditMessage iAuditMessage) {
        SensitiveWordsManager.getInstance().filterSensitiveWords(msg, new IFilterSensitiveWordsResultListener(){

            @Override
            public void onFilterResult(boolean pass, String message, String keywords) {
                if (pass) {
                    VssRoomManager.this.sendMessageImpl(message, type, callBack, iAuditMessage);
                }
            }

            @Override
            public void showToast(String message) {
                callBack.onError(-1, message);
            }
        });
    }

    private void sendMessageImpl(String msg, String type, CallBack callBack, IAuditMessage iAuditMessage) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            type = "text";
        }
        if (this.im != null) {
            if ("service_custom".equals(type)) {
                this.im.sendCustomMsg(msg, (VHIM.Callback)new SimpleVHIMCallback(callBack));
                return;
            }
            int role = 0;
            try {
                role = InternalUtils.strToInt(VssRoomManager.getInstance().getRoomInfo().getRole_name());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IAuditMessage.AuditMessageContextBuilder builder = new IAuditMessage.AuditMessageContextBuilder().setRoleName(role).setNickName(AccountManager.getInstance().getNickName());
            IAuditMessage message = new IAuditMessage.AuditMessageBuilder().setAudit("0").setContext(builder.build().buildJsonContext().toString()).setType(type).setMessageText(msg).build();
            this.sendMessageInternalImpl(iAuditMessage == null ? message : iAuditMessage, callBack, null);
        } else if (callBack != null) {
            callBack.onError(-1, "\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    private void sendMessageInternalImpl(IAuditMessage msg, CallBack callback, List<String> images) {
        IBody body = new IBody.Builder().setTextContent(msg.getMessageText()).setImageUrls(images).setType(msg.getType()).build();
        IVHMessage message = new IVHMessage.Builder().setIBody(body).setContext(msg.getContext()).setNoAudit(msg.getNoAudit()).build();
        this.im.sendMsg(message, (VHIM.Callback)new SimpleVHIMCallback(callback));
    }

    public void sendQuestionAnswer(String msg, String is_show, final CallBack callBack) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("room_join_id", String.valueOf(roomInfo.getAccount_id()));
        params.put("content", TextUtils.isEmpty((CharSequence)msg) ? "" : msg);
        params.put("is_show", TextUtils.isEmpty((CharSequence)is_show) ? "0" : is_show);
        CommonManagerNetWrapper.createQa(params, new CallBack<String>(){

            @Override
            public void onSuccess(String result) {
                callBack.onSuccess(result);
            }

            @Override
            public void onError(int eventCode, String msg) {
            }
        });
    }

    public void sendImageMsg(String text, List<String> imageUrls, CallBack callBack) {
        if (this.im != null) {
            int role = 0;
            try {
                role = InternalUtils.strToInt(VssRoomManager.getInstance().getRoomInfo().getRole_name());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IAuditMessage.AuditMessageContextBuilder builder = new IAuditMessage.AuditMessageContextBuilder().setRoleName(role).setNickName(AccountManager.getInstance().getNickName());
            IAuditMessage message = new IAuditMessage.AuditMessageBuilder().setAudit(EnumRoleName.isHost(role) ? "1" : "0").setContext(builder.build().buildJsonContext().toString()).setType("image").setMessageText(text).build();
            this.sendMessageInternalImpl(message, callBack, imageUrls);
        } else {
            if (callBack == null) {
                return;
            }
            callBack.onError(-1, "\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    public void setVssMessageListener(IVssMessageListener iVssMessageListener) {
        this.messageListenerList.add(iVssMessageListener);
    }

    public void removeVssMessageListener(IVssMessageListener iVssMessageListener) {
        this.messageListenerList.remove(iVssMessageListener);
    }

    private void interestingInternalEvent(String type, ResponseImMessageInfo responseImMessageInfo) {
        for (IInterceptor iInterceptor : this.iInterceptors) {
            iInterceptor.onMessage(type, responseImMessageInfo);
        }
        switch (type) {
            case "vrtc_big_screen_set": {
                if (responseImMessageInfo == null) break;
                try {
                    JSONObject dataJson = new JSONObject(responseImMessageInfo.getData());
                    this.mainScreenId = dataJson.optString("target_id");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void leaveRoom(String channelId, IVssMessageListener listener) {
        if (this.ims != null && this.ims.size() > 0 && !TextUtils.isEmpty((CharSequence)channelId)) {
            if (this.ims.containsKey(channelId)) {
                VHIM vhim = this.ims.get(channelId);
                if (vhim != null) {
                    vhim.leave();
                }
                this.ims.remove(channelId);
                if (listener != null && this.messageListenerList != null && this.messageListenerList.contains(listener)) {
                    this.messageListenerList.remove(listener);
                }
            }
        } else {
            if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
                this.mDisposable.dispose();
            }
            enter = false;
            instance = null;
            if (this.im != null) {
                this.im.leave();
                this.im = null;
            }
            this.messageListenerList.clear();
            roomInfo = null;
            vssToken = null;
            roomId = null;
        }
    }

    public Map<String, InteractiveUserBean> getInteractiveUsers() {
        return this.mInteractiveListResponseBeanMap;
    }

    static {
        enter = false;
    }

    class MsgListenerInternalImpl
    implements VHIM.OnMessageListener {
        MsgListenerInternalImpl() {
        }

        public void onMessage(String msg) {
            try {
                ResponseImMessageInfo responseImMessageInfo = (ResponseImMessageInfo)JSON.parseObject((String)msg, ResponseImMessageInfo.class);
                if (!TextUtils.isEmpty((CharSequence)responseImMessageInfo.getData())) {
                    this.scheduleMessage(responseImMessageInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onChannelStatus(String s) {
        }

        private void dispatchMessage(String type, Object data, ResponseImMessageInfo responseImMessageInfo) {
            if (VssRoomManager.this.messageListenerList != null && VssRoomManager.this.messageListenerList.size() > 0) {
                for (IVssMessageListener iVssMessageListener : VssRoomManager.this.messageListenerList) {
                    if (iVssMessageListener == null) continue;
                    try {
                        iVssMessageListener.onMessage(new MessageData(type, data, responseImMessageInfo));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        private void scheduleMessage(ResponseImMessageInfo responseImMessageInfo) {
            try {
                String type = "-1";
                try {
                    JSONObject objData = new JSONObject(responseImMessageInfo.getData());
                    type = objData.optString("type");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                VssRoomManager.this.interestingInternalEvent(type, responseImMessageInfo);
                this.dispatchMessage(type, responseImMessageInfo, responseImMessageInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class SimpleVHIMCallback
    implements VHIM.Callback {
        private CallBack callBack;

        public SimpleVHIMCallback(CallBack callBack) {
            this.callBack = callBack;
        }

        public void onSuccess() {
            if (this.callBack != null) {
                this.callBack.onSuccess(null);
            }
        }

        public void onFailure(int errorCode, String errorMsg) {
            if (this.callBack == null) {
                return;
            }
            this.callBack.onError(errorCode, errorMsg);
        }
    }
}

