/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.room;

import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.vhall.appui.baselib.utils.LogUtils;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.data.ResponseChatInfo;
import com.vhall.appui.baselib.vss.data.ResponseImMessageInfo;
import com.vhall.appui.baselib.vss.data.VssMessageAnnouncementData;
import com.vhall.appui.baselib.vss.data.VssMessageChatData;
import com.vhall.appui.baselib.vss.data.VssMessageLotteryData;
import com.vhall.appui.baselib.vss.data.VssMessageSignData;
import com.vhall.appui.baselib.vss.module.room.callback.IVssMessageListener;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class VssRoomInternal {
    private IVssMessageListener messageListener;
    private String thirdPartId;
    private String roleName;
    private boolean filterOtherMsg;

    public VssRoomInternal(IVssMessageListener messageListener, String thirdPartId, String roleName, boolean filterOtherMsg) {
        this.thirdPartId = thirdPartId;
        this.roleName = roleName;
        this.messageListener = messageListener;
        this.filterOtherMsg = filterOtherMsg;
    }

    private void sendMessage(String type, Object data, ResponseImMessageInfo responseImMessageInfo) {
        this.messageListener.onMessage(new MessageData(type, data, responseImMessageInfo));
    }

    public void dealMessage(ResponseImMessageInfo responseImMessageInfo) {
        try {
            String type;
            JSONObject objData;
            JSONObject objCon = null;
            if (!TextUtils.isEmpty((CharSequence)responseImMessageInfo.getContext())) {
                objCon = new JSONObject(responseImMessageInfo.getContext());
            }
            try {
                objData = new JSONObject(responseImMessageInfo.getData());
                type = objData.optString("type");
            }
            catch (Exception e) {
                objData = null;
                type = "-1";
            }
            String id2 = "";
            if (TextUtils.isEmpty((CharSequence)responseImMessageInfo.getService_type())) {
                LogUtils.e("service_type is null " + responseImMessageInfo);
            } else {
                switch (responseImMessageInfo.getService_type()) {
                    case "service_im": {
                        this.processIm(responseImMessageInfo, objCon, objData, type);
                        break;
                    }
                    case "service_custom": {
                        this.processCustomMessage(responseImMessageInfo, objCon);
                        break;
                    }
                    case "service_online": {
                        this.processOnlineMessage(responseImMessageInfo, objCon, objData, type);
                        break;
                    }
                    case "service_room": 
                    case "record_default_set": {
                        this.processRoomMessage(responseImMessageInfo, objData, type);
                        break;
                    }
                    default: {
                        this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                    }
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void processRoomMessage(ResponseImMessageInfo responseImMessageInfo, JSONObject objData, String type) throws JSONException {
        switch (type) {
            case "lottery_push": 
            case "lottery_result_notice": {
                break;
            }
            case "sign_in_push": {
                this.dealData(responseImMessageInfo, type, VssMessageSignData.class);
                break;
            }
            case "room_announcement": {
                this.dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                break;
            }
            case "questionnaire_push": 
            case "questionnaire_repush": {
                String questionnaire_id = objData.optString("questionnaire_id");
                JSONObject question = new JSONObject();
                question.put("questionnaire_id", (Object)questionnaire_id);
                this.sendMessage(type, question, responseImMessageInfo);
                break;
            }
            case "vrtc_connect_apply": 
            case "vrtc_connect_apply_cancel": 
            case "vrtc_connect_invite_refused": 
            case "vrtc_connect_success": {
                if (!TextUtils.equals((CharSequence)"1", (CharSequence)this.roleName)) break;
                JSONObject apply = new JSONObject();
                apply.put("nick_name", (Object)objData.optString("nick_name"));
                apply.put("user_id", (Object)objData.optString("room_join_id"));
                this.sendMessage(type, apply, responseImMessageInfo);
                break;
            }
            case "vrtc_connect_invite": 
            case "kick_out": 
            case "vrtc_connect_agree": 
            case "vrtc_connect_refused": {
                String id2 = objData.optString("target_id");
                if (TextUtils.isEmpty((CharSequence)id2) || this.isFilterMsg(id2)) break;
                this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                break;
            }
            case "vrtc_frames_forbid": 
            case "vrtc_mute_cancel": 
            case "vrtc_mute": 
            case "vrtc_frames_display": 
            case "vrtc_disconnect_success": {
                if (!this.roleName.equals("1")) {
                    String id3 = objData.optString("target_id");
                    if (TextUtils.isEmpty((CharSequence)id3) || this.isFilterMsg(id3)) break;
                    JSONObject status = new JSONObject();
                    status.put("user_id", (Object)objData.optString("target_id"));
                    this.sendMessage(type, status, responseImMessageInfo);
                    break;
                }
                JSONObject status = new JSONObject();
                status.put("user_id", (Object)objData.optString("target_id"));
                this.sendMessage(type, status, responseImMessageInfo);
                break;
            }
            default: {
                this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
            }
        }
    }

    private void processOnlineMessage(ResponseImMessageInfo responseImMessageInfo, JSONObject objCon, JSONObject objData, String type) throws JSONException {
        String hide = objData.optString("hide");
        if ("1".equals(hide)) {
            return;
        }
        JSONObject online = new JSONObject();
        online.put("time", (Object)responseImMessageInfo.getDate_time());
        online.put("id", (Object)responseImMessageInfo.getSender_id());
        if (objCon != null) {
            if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                online.put("name", (Object)objCon.optString("nickname"));
            } else {
                online.put("name", (Object)objCon.optString("nick_name"));
            }
            online.put("avatar", (Object)objCon.optString("avatar"));
        }
        this.sendMessage(type, online, responseImMessageInfo);
    }

    private void processCustomMessage(ResponseImMessageInfo responseImMessageInfo, JSONObject objCon) {
        VssMessageChatData chatData = new VssMessageChatData();
        if (objCon != null) {
            chatData.setAvatar(objCon.optString("avatar"));
            chatData.setRoom_id(objCon.optString("room_id"));
            chatData.setRoleName(objCon.optString("role_name"));
            if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                chatData.setNickname(objCon.optString("nickname"));
            } else {
                chatData.setNickname(objCon.optString("nick_name"));
            }
            chatData.setRoleName(objCon.optString("role_name"));
        }
        chatData.setTime(responseImMessageInfo.getDate_time());
        chatData.setType("text");
        chatData.event = "custom_broadcast";
        chatData.setText_content(responseImMessageInfo.getData());
        chatData.setUserId(responseImMessageInfo.getSender_id());
        chatData.setMy(responseImMessageInfo.getSender_id().equals(this.thirdPartId));
        this.sendMessage("service_custom", chatData, responseImMessageInfo);
    }

    private void processIm(ResponseImMessageInfo responseImMessageInfo, JSONObject objCon, JSONObject objData, String type) throws JSONException {
        switch (type) {
            case "forbidden_words": {
                String id2 = objData.optString("target_id");
                if (TextUtils.isEmpty((CharSequence)id2) || !TextUtils.equals((CharSequence)id2, (CharSequence)this.thirdPartId)) break;
            }
            case "permit_words": {
                String id2 = objData.optString("target_id");
                if (TextUtils.isEmpty((CharSequence)id2) || !TextUtils.equals((CharSequence)id2, (CharSequence)this.thirdPartId)) break;
            }
            case "disable_all": 
            case "permit_all": {
                this.sendMessage(type, null, responseImMessageInfo);
                break;
            }
            case "image": 
            case "text": {
                String roleNameText;
                JSONArray image_urls;
                VssMessageChatData chatData = new VssMessageChatData();
                ArrayList<ResponseChatInfo.ContextBean.AtListBean> atList = new ArrayList();
                if (objCon != null) {
                    chatData.setAvatar(objCon.optString("avatar"));
                    chatData.setRoom_id(objCon.optString("room_id"));
                    chatData.setRoleName(objCon.optString("role_name"));
                    if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                        chatData.setNickname(objCon.optString("nickname"));
                    } else {
                        chatData.setNickname(objCon.optString("nick_name"));
                    }
                    String replyMsg = objCon.optString("replyMsg").trim();
                    if (TextUtils.isEmpty((CharSequence)replyMsg) || replyMsg.startsWith("[")) {
                        Log.i((String)"message", (String)"error replyMsg");
                    } else if (replyMsg.startsWith("{")) {
                        VssMessageChatData.ReplyMsgBean replyMsgBean = (VssMessageChatData.ReplyMsgBean)JSON.parseObject((String)replyMsg, VssMessageChatData.ReplyMsgBean.class);
                        chatData.setReplyMsg(replyMsgBean);
                    }
                    JSONArray atListArray = objCon.optJSONArray("atList");
                    if (atListArray != null && atListArray.length() > 0) {
                        atList = JSON.parseArray((String)atListArray.toString(), ResponseChatInfo.ContextBean.AtListBean.class);
                        chatData.setAtlist(atList);
                    }
                }
                if ((image_urls = objData.optJSONArray("image_urls")) != null) {
                    ArrayList<String> urls = new ArrayList<String>();
                    for (int i = 0; i < image_urls.length(); ++i) {
                        urls.add(image_urls.get(i).toString());
                    }
                    chatData.setImage_urls(urls);
                }
                chatData.setTime(responseImMessageInfo.getDate_time());
                chatData.setType(type);
                String textContent = objData.optString("text_content");
                if (atList.size() > 0) {
                    for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                        textContent = textContent.replace("***" + bean.getNickName(), "@" + bean.getNickName());
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(roleNameText = objData.optString("roleNameText")))) {
                    chatData.setRoleNameTextBean((VssMessageChatData.RoleNameTextBean)JSON.parseObject((String)roleNameText, VssMessageChatData.RoleNameTextBean.class));
                }
                chatData.setText_content(textContent);
                chatData.setImage_url(objData.optString("image_url"));
                chatData.setUserId(responseImMessageInfo.getSender_id());
                chatData.setMy(responseImMessageInfo.getSender_id().equals(this.thirdPartId));
                chatData.setMsg_id(responseImMessageInfo.getMsg_id());
                this.sendMessage(type, chatData, responseImMessageInfo);
                break;
            }
            default: {
                this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
            }
        }
    }

    private void dealData(ResponseImMessageInfo responseImMessageInfo, String type, Class c) {
        Object data = JSON.parseObject((String)responseImMessageInfo.getData(), (Class)c);
        if (data != null) {
            this.sendMessage(type, data, responseImMessageInfo);
        }
    }

    private void dealLottery(ResponseImMessageInfo responseImMessageInfo, String type) {
        VssMessageLotteryData lotteryData = (VssMessageLotteryData)JSON.parseObject((String)responseImMessageInfo.getData(), VssMessageLotteryData.class);
        if (lotteryData != null) {
            List<VssMessageLotteryData.LotteryWinnersBean> lottery_winners = lotteryData.getLottery_winners();
            if (lottery_winners != null && lottery_winners.size() > 0) {
                for (int i = 0; i < lottery_winners.size(); ++i) {
                    VssMessageLotteryData.LotteryWinnersBean lotteryWinnersBean = lottery_winners.get(i);
                    if (lotteryWinnersBean.getLottery_user_id().equals(this.thirdPartId)) {
                        lotteryWinnersBean.setSelf(true);
                        continue;
                    }
                    lotteryWinnersBean.setSelf(false);
                }
            }
            this.sendMessage(type, lotteryData, responseImMessageInfo);
        }
    }

    private boolean isFilterMsg(String id2) {
        if (TextUtils.equals((CharSequence)id2, (CharSequence)this.thirdPartId)) {
            return false;
        }
        return this.filterOtherMsg;
    }

    void setFilterOtherMsg(boolean filterOtherMsg) {
        this.filterOtherMsg = filterOtherMsg;
    }
}

