/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.question;

import android.text.TextUtils;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.api.ApiFactory;
import com.vhall.appui.baselib.vss.api.HttpManager;
import com.vhall.appui.baselib.vss.data.CreateQuestionParam;
import com.vhall.appui.baselib.vss.data.VssQuestionListData;
import com.vhall.appui.baselib.vss.utils.rxutils.BaseVhallVssHttp;
import com.vhall.appui.baselib.vss.utils.rxutils.ResponseTransformer;
import com.vhall.appui.baselib.vss.utils.schedulers.SchedulerProvider;
import io.reactivex.functions.Consumer;
import java.util.HashMap;

public class VssQuestionManager
extends BaseVhallVssHttp {
    private static volatile VssQuestionManager instance;
    private static String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssQuestionManager getInstance() {
        if (instance != null) return instance;
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            if (instance != null) return instance;
            instance = new VssQuestionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void questionCreate(CreateQuestionParam createQuestionParam, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 10);
        if (createQuestionParam != null) {
            params.put("title", createQuestionParam.getTitle());
            params.put("definition", createQuestionParam.getDescription());
            params.put("question_id", createQuestionParam.getQuestion_id());
            params.put("cover", createQuestionParam.getCover());
            params.put("extend", createQuestionParam.getExtend());
            params.put("is_public", createQuestionParam.getIs_public());
            params.put("account_id", createQuestionParam.getAccount_id());
            params.put("app_id", createQuestionParam.getApp_id());
        }
        this.addSubscribe(ApiFactory.getApiSingleton().questionCreate(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void questionAnswer(String answerId, String questionId, String extend, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("answer_id", answerId);
        params.put("question_id", questionId);
        if (!TextUtils.isEmpty((CharSequence)extend)) {
            params.put("extend", extend);
        }
        this.addSubscribe(ApiFactory.getApiSingleton().questionAnswer(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void questionStatisticsList(String page, String pageSize, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("page", page);
        params.put("page_size", pageSize);
        this.addSubscribe(ApiFactory.getApiSingleton().questionStatisticsList(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void questionList(CallBack callback) {
        this.questionList("", "", "", "", "", callback);
    }

    public void questionList(String keyword, String publish, String isPublic, String page, String pageSize, final CallBack<VssQuestionListData> callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 7);
        params.put("page", page);
        params.put("page_size", pageSize);
        params.put("keyword", keyword);
        params.put("is_public", isPublic);
        params.put("publish", publish);
        params.put("from_room_id", roomId);
        this.addSubscribe(ApiFactory.getApiSingleton().questionList(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<VssQuestionListData>(){

            public void accept(VssQuestionListData s) {
                callback.onSuccess(s);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void questionCancelPublish(String vssToken, String roomId, String questionId, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("question_id", questionId);
        this.addSubscribe(ApiFactory.getApiSingleton().questionCancelPublish(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void questionPublish(String vssToken, String roomId, String questionId, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("question_id", questionId);
        this.addSubscribe(ApiFactory.getApiSingleton().questionPublish(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void questionUpdate(String vssToken, CreateQuestionParam createQuestionParam, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, null, 7);
        params.put("question_id", createQuestionParam.getQuestion_id());
        params.put("definition", createQuestionParam.getDescription());
        params.put("title", createQuestionParam.getTitle());
        params.put("extend", createQuestionParam.getExtend());
        params.put("cover", createQuestionParam.getCover());
        params.put("account_id", createQuestionParam.getAccount_id());
        this.addSubscribe(ApiFactory.getApiSingleton().questionUpdate(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void questionWatchList(String vssToken, String roomId, String keyword, String page, String pageSize, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("keyword", keyword);
        params.put("page", page);
        params.put("page_size", pageSize);
        this.addSubscribe(ApiFactory.getApiSingleton().questionWatchList(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssQuestionManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    static {
        TAG = "VssQaManager";
    }
}

