/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.lottery;

import android.text.TextUtils;
import android.util.Log;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.api.ApiFactory;
import com.vhall.appui.baselib.vss.api.HttpManager;
import com.vhall.appui.baselib.vss.utils.rxutils.BaseVhallVssHttp;
import com.vhall.appui.baselib.vss.utils.rxutils.ResponseTransformer;
import com.vhall.appui.baselib.vss.utils.schedulers.SchedulerProvider;
import io.reactivex.functions.Consumer;
import java.util.HashMap;

public class VssLotteryManager
extends BaseVhallVssHttp {
    private static volatile VssLotteryManager instance;
    private static String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssLotteryManager getInstance() {
        if (roomInfo == null) {
            Log.e((String)TAG, (String)"room data error");
        }
        if (instance != null) return instance;
        Class<VssLotteryManager> clazz = VssLotteryManager.class;
        synchronized (VssLotteryManager.class) {
            if (instance != null) return instance;
            instance = new VssLotteryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void lotteryAdd(String lottery_type, String lottery_number, String lottery_user_ids, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("lottery_type", lottery_type);
        params.put("lottery_number", lottery_number);
        params.put("lottery_user_ids", lottery_user_ids);
        this.addSubscribe(ApiFactory.getApiSingleton().lotteryAdd(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssLotteryManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void lotteryEnd(String lottery_id, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("lottery_id", lottery_id);
        this.addSubscribe(ApiFactory.getApiSingleton().lotteryEnd(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssLotteryManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void lotteryUsersGet(String lottery_id, String offset, String limit, String sort_type, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 6);
        params.put("lottery_id", lottery_id);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort_type", sort_type);
        this.addSubscribe(ApiFactory.getApiSingleton().lotteryUsersGet(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssLotteryManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void lotteryGets(String lottery_type, String offset, String limit, String sort_type, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 6);
        params.put("lottery_type", lottery_type);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort_type", sort_type);
        this.addSubscribe(ApiFactory.getApiSingleton().lotteryGets(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssLotteryManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void lotteryAward(String lottery_id, String lottery_user_name, String lottery_user_phone, String lottery_user_remark, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 6);
        params.put("lottery_id", lottery_id);
        params.put("lottery_user_name", lottery_user_name);
        params.put("lottery_user_phone", lottery_user_phone);
        if (!TextUtils.isEmpty((CharSequence)lottery_user_remark)) {
            params.put("lottery_user_remark", lottery_user_remark);
        }
        this.addSubscribe(ApiFactory.getApiSingleton().lotteryAward(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssLotteryManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void lotteryCount(String lottery_type, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("lottery_type", lottery_type);
        this.addSubscribe(ApiFactory.getApiSingleton().lotteryCount(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssLotteryManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void lotterySearch(String lottery_type, String keyword, final CallBack callback) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("keyword", keyword);
        params.put("lottery_type", lottery_type);
        this.addSubscribe(ApiFactory.getApiSingleton().lotterySearch(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssLotteryManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    static {
        TAG = "VssLotteryManager";
    }
}

