/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.doc;

import android.text.TextUtils;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.VssSdk;
import com.vhall.appui.baselib.vss.api.ApiFactory;
import com.vhall.appui.baselib.vss.api.HttpManager;
import com.vhall.appui.baselib.vss.data.ResponseDocListInfo;
import com.vhall.appui.baselib.vss.utils.rxutils.BaseVhallVssHttp;
import com.vhall.appui.baselib.vss.utils.rxutils.ResponseTransformer;
import com.vhall.appui.baselib.vss.utils.schedulers.SchedulerProvider;
import com.vhall.framework.VhallSDK;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class VssDocumentManager
extends BaseVhallVssHttp {
    private static volatile VssDocumentManager instance;
    private static String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssDocumentManager getInstance() {
        if (roomInfo == null) {
            Log.e((String)TAG, (String)"room data error");
        }
        if (instance != null) return instance;
        Class<VssDocumentManager> clazz = VssDocumentManager.class;
        synchronized (VssDocumentManager.class) {
            if (instance != null) return instance;
            instance = new VssDocumentManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void documentDelete(String paasdocumentId, final CallBack callback) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 3);
        params.put("paas_document_id", paasdocumentId);
        this.addSubscribe(ApiFactory.getApiSingleton().documentDelete(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                callback.onSuccess(null);
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssDocumentManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public static String getExtensionName(String fileName) {
        int dot;
        if (fileName != null && fileName.length() > 0 && (dot = fileName.lastIndexOf(".")) > -1 && dot < fileName.length() - 1) {
            return fileName.substring(dot + 1);
        }
        return "";
    }

    public void docUpload(File file, final CallBack<String> callback) {
        if (file == null) {
            callback.onError(-1, "file is  null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)"vss_token")) {
            if (callback != null) {
                callback.onError(-1, "vssToken \u4e0d\u80fd\u4e3a\u7a7a");
            }
            return;
        }
        if (!VhallSDK.getInstance().documentExt.contains(VssDocumentManager.getExtensionName(file.getName()))) {
            if (callback != null) {
                callback.onError(-1, "document type error");
            }
            return;
        }
        if (file.length() > (long)VhallSDK.getInstance().documentMaxSize) {
            int max = VhallSDK.getInstance().documentMaxSize / 1024 / 1024;
            callback.onError(-1, "The maximum file size is  " + max + "M");
            return;
        }
        RequestBody fileBody = RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("document", file.getName(), fileBody).addFormDataPart("vss_token", vssToken).addFormDataPart("room_id", roomId).addFormDataPart("app_id", VssSdk.getInstance().getAppId()).addFormDataPart("from", "android_app").build();
        this.addSubscribe(ApiFactory.getApiSingleton().documentUpload(requestBody).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<String>(){

            public void accept(String s) {
                if (callback != null) {
                    JSONObject object = (JSONObject)JSONObject.parse((String)s);
                    if (object.containsKey((Object)"document_id")) {
                        callback.onSuccess(object.getString("document_id"));
                    } else {
                        callback.onError(-1, "\u8bf7\u6c42\u7ed3\u679c\u89e3\u6790\u9519\u8bef");
                    }
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssDocumentManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    public void documentLists(String accountId, String fileName, final CallBack callback) {
        HashMap<String, String> params = this.getVssTokenAndIdParam(vssToken, roomId, 4);
        params.put("account_id", accountId);
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            params.put("file_name", fileName);
        }
        this.addSubscribe(ApiFactory.getApiSingleton().documentLists(HttpManager.getRequestBody(params)).compose(ResponseTransformer.handleResult()).compose(SchedulerProvider.getInstance().applySchedulers()).subscribe((Consumer)new Consumer<ResponseDocListInfo>(){

            public void accept(ResponseDocListInfo s) {
                if (callback != null) {
                    callback.onSuccess(s);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable e) {
                VssDocumentManager.this.dealError(e, callback, TAG);
            }
        }));
    }

    static {
        TAG = "VssDocumentManager";
    }
}

