/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.module.chat;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public interface IAuditMessage {
    public String getContext();

    public String getMessageText();

    public String getType();

    public String getNoAudit();

    public static class AuditMessageContextBuilder {
        static final String KEY_NICK_NAME = "nickname";
        static final String KEY_AVATAR = "avatar";
        static final String KEY_ROLE_NAME = "role_name";
        static final String KEY_REPLAY_MSG = "replyMsg";
        static final String KEY_AT_LIST = "atList";
        static final String KEY_ROLE_NAME_TEXT = "roleNameText";
        private String nickName = "";
        private String avatar = "";
        private int roleName;
        private JSONObject replayMsg = new JSONObject();
        private JSONArray atList = new JSONArray();
        private JSONObject roleNameText = new JSONObject();

        public AuditMessageContextBuilder setNickName(String nickName) {
            this.nickName = nickName;
            return this;
        }

        public AuditMessageContextBuilder setAvatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public AuditMessageContextBuilder setRoleName(int roleName) {
            this.roleName = roleName;
            return this;
        }

        public AuditMessageContextBuilder setReplayMsg(JSONObject replayMsg) {
            this.replayMsg = replayMsg;
            return this;
        }

        public AuditMessageContextBuilder setAtList(JSONArray atList) {
            this.atList = atList;
            return this;
        }

        public AuditMessageContextBuilder setRoleNameText(JSONObject roleNameText) {
            this.roleNameText = roleNameText;
            return this;
        }

        public AuditMessageContext build() {
            return new AuditMessageContext(){

                @Override
                public String getNickName() {
                    return nickName;
                }

                @Override
                public String getAvatar() {
                    return avatar;
                }

                @Override
                public int getRoleName() {
                    return roleName;
                }

                @Override
                public JSONObject getReplayMsg() {
                    return replayMsg;
                }

                @Override
                public JSONArray getAtList() {
                    return atList;
                }

                @Override
                public JSONObject getRoleNameText() {
                    return roleNameText;
                }

                @Override
                public JSONObject buildJsonContext() {
                    JSONObject jsonObject = new JSONObject();
                    try {
                        jsonObject.put(AuditMessageContextBuilder.KEY_NICK_NAME, (Object)nickName);
                        jsonObject.put(AuditMessageContextBuilder.KEY_AVATAR, (Object)avatar);
                        jsonObject.put(AuditMessageContextBuilder.KEY_ROLE_NAME, roleName);
                        jsonObject.put(AuditMessageContextBuilder.KEY_REPLAY_MSG, (Object)replayMsg);
                        jsonObject.put(AuditMessageContextBuilder.KEY_AT_LIST, (Object)atList);
                        jsonObject.put(AuditMessageContextBuilder.KEY_ROLE_NAME_TEXT, (Object)roleNameText);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    return jsonObject;
                }
            };
        }
    }

    public static class AuditMessageBuilder {
        private String messageText;
        private String context;
        private String type = "text";
        private String noAudit;

        public AuditMessageBuilder setMessageText(String messageText) {
            this.messageText = messageText;
            return this;
        }

        public AuditMessageBuilder setContext(String context) {
            this.context = context;
            return this;
        }

        public AuditMessageBuilder setType(String type) {
            this.type = type;
            return this;
        }

        public AuditMessageBuilder setAudit(String noAudit) {
            this.noAudit = noAudit;
            return this;
        }

        public IAuditMessage build() {
            return new IAuditMessage(){

                @Override
                public String getMessageText() {
                    return messageText;
                }

                @Override
                public String getContext() {
                    return context;
                }

                @Override
                public String getType() {
                    return type;
                }

                @Override
                public String getNoAudit() {
                    return noAudit;
                }
            };
        }
    }

    public static interface AuditMessageContext {
        public String getNickName();

        public String getAvatar();

        public int getRoleName();

        public JSONObject getReplayMsg();

        public JSONArray getAtList();

        public JSONObject getRoleNameText();

        public JSONObject buildJsonContext();
    }
}

