/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.data;

import android.text.TextUtils;
import android.view.View;
import com.vhall.appui.baselib.service.chat.processor.IChatProcessor;
import com.vhall.appui.baselib.utils.ListUtils;
import com.vhall.appui.baselib.vss.data.EnumRoleName;
import com.vhall.appui.baselib.vss.data.ResponseChatInfo;
import com.vhall.appui.baselib.vss.service.IMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VssMessageChatData
implements Serializable,
IMessage {
    private String text_content;
    private String type;
    private String room_id;
    private String nickname;
    private String avatar;
    private String userId;
    private String time;
    private String image_url;
    private boolean isMy;
    private List<String> image_urls;
    private String roleName;
    private String msg_id;
    private boolean isQAMsg = false;
    private JumpMsgBean jumpMsgBean;
    public String event = "msg";
    public static final String eventOnlineKey = "online";
    public static final String eventMsgKey = "msg";
    public static final String eventCustomKey = "custom_broadcast";
    private ReplyMsgBean replyMsg;
    private List<ResponseChatInfo.ContextBean.AtListBean> atList;
    private RoleNameTextBean roleNameTextBean;
    private IChatProcessor processor;

    public boolean isQAMsg() {
        return this.isQAMsg;
    }

    public void setQAMsg(boolean QAMsg) {
        this.isQAMsg = QAMsg;
    }

    public String getMsg_id() {
        return this.msg_id;
    }

    public void setMsg_id(String msg_id) {
        this.msg_id = msg_id;
    }

    public String getReceiver_id() {
        String id2 = "*";
        if (!ListUtils.isEmpty(this.atList)) {
            for (int i = 0; i < this.atList.size(); ++i) {
                id2 = id2 + this.atList.get(i).getAccountId() + "*";
            }
        }
        return id2;
    }

    public void setRoleNameTextBean(RoleNameTextBean roleNameTextBean) {
        this.roleNameTextBean = roleNameTextBean;
    }

    @Override
    public void setChatProcessor(IChatProcessor processor) {
        this.processor = processor;
    }

    @Override
    public IChatProcessor getChatProcessor() {
        return this.processor;
    }

    public List<ResponseChatInfo.ContextBean.AtListBean> getAtlist() {
        return this.atList;
    }

    public void setAtlist(List<ResponseChatInfo.ContextBean.AtListBean> atlist) {
        this.atList = atlist;
    }

    @Override
    public String getText_content() {
        return this.text_content;
    }

    public void setText_content(String text_content) {
        this.text_content = text_content;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getRoom_id() {
        return this.room_id;
    }

    public void setRoom_id(String room_id) {
        this.room_id = room_id;
    }

    @Override
    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public boolean isMy() {
        return this.isMy;
    }

    @Override
    public JumpMsgBean getJumpMsgBean() {
        return this.jumpMsgBean;
    }

    public void setJumpMsgBean(JumpMsgBean jumpMsgBean) {
        this.jumpMsgBean = jumpMsgBean;
    }

    public void setMy(boolean my) {
        this.isMy = my;
    }

    public String getImage_url() {
        return this.image_url;
    }

    public void setImage_url(String image_url) {
        this.image_url = image_url;
    }

    @Override
    public List<String> getImage_urls() {
        if (ListUtils.isEmpty(this.image_urls) && !TextUtils.isEmpty((CharSequence)this.image_url)) {
            this.image_urls = new ArrayList<String>();
            this.image_urls.add(this.image_url);
        }
        return this.image_urls;
    }

    public void setImage_urls(List<String> image_urls) {
        this.image_urls = image_urls;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public VssMessageChatData getMsgData(ResponseChatInfo chatInfo) {
        VssMessageChatData chatData = new VssMessageChatData();
        chatData.setUserId(chatInfo.getThird_party_user_id());
        chatData.setAvatar(chatInfo.getAvatar());
        chatData.setNickname(chatInfo.getNickname());
        chatData.setTime(chatInfo.getDate_time());
        String contentString = chatInfo.getData().getText_content();
        List<ResponseChatInfo.ContextBean.AtListBean> atList = chatInfo.getContext().getAtList();
        if (atList != null && atList.size() > 0) {
            for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                contentString = contentString.replace("***" + bean.getNickName(), "@" + bean.getNickName());
            }
        }
        chatData.setText_content(contentString);
        chatData.setType(chatInfo.getData().getType());
        chatData.setImage_urls(chatInfo.getData().getImage_urls());
        return chatData;
    }

    public ReplyMsgBean getReplyMsg() {
        return this.replyMsg;
    }

    public void setReplyMsg(ReplyMsgBean replyMsg) {
        this.replyMsg = replyMsg;
    }

    @Override
    public int getMsgType() {
        if (this.isQAMsg) {
            return 3;
        }
        int type = 0;
        if (this.atList != null && this.atList.size() > 0) {
            type = 1;
        } else if (this.replyMsg != null && this.replyMsg.content != null && !TextUtils.isEmpty((CharSequence)((ReplyMsgBean)this.replyMsg).content.text_content)) {
            type = 2;
        }
        return type;
    }

    @Override
    public String getOperateNickName() {
        String nickName = "";
        if (this.getMsgType() == 1) {
            for (int i = this.atList.size() - 1; i >= 0; --i) {
                nickName = nickName + " @" + this.atList.get(i).getNickName();
            }
        } else if (this.getMsgType() == 2 && !TextUtils.isEmpty((CharSequence)this.replyMsg.nickName)) {
            nickName = this.replyMsg.nickName;
        }
        return nickName.replaceFirst(" ", "");
    }

    @Override
    public String getRoleNameText() {
        EnumRoleName type = EnumRoleName.getRole(this.roleName);
        return type != null ? type.name : "";
    }

    @Override
    public String getOriginText() {
        try {
            return new JSONArray(this.replyMsg.getContent().text_content).optJSONObject(0).optString("msgCont");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public List<String> getOriginImage_urls() {
        try {
            return this.replyMsg.getContent().getImage_urls();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    @Override
    public String getMsgId() {
        return this.msg_id;
    }

    @Override
    public String getDateTime() {
        return this.time;
    }

    public static class JumpMsgBean {
        public static final int msgTypeQa = 1;
        public static final int msgTypeQaAnswer = 2;
        public static final int msgTypeVote = 3;
        public static final int msgTypeExam = 4;
        public String url;
        public String id;
        public int msgType;
        public String jumpMsg = " \u70b9\u51fb\u53c2\u4e0e";
        public View.OnClickListener onClickListener;
        public boolean jump = false;

        public JumpMsgBean() {
        }

        public JumpMsgBean(String url, String id2, int msgType, String jumpMsg) {
            this.url = url;
            this.id = id2;
            this.msgType = msgType;
            this.jumpMsg = jumpMsg;
        }
    }

    public static class ReplyMsgBean {
        private String type;
        private String avatar;
        private String sendId;
        private String nickName;
        private String roleName;
        private VssMessageChatData content;
        private String showTime;
        private String sendTime;
        private String client;
        private int count;
        private String msgId;
        private String channel;
        private boolean isHistoryMsg;
        private List<?> replyMsg;
        private List<?> atList;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAvatar() {
            return this.avatar;
        }

        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        public String getSendId() {
            return this.sendId;
        }

        public void setSendId(String sendId) {
            this.sendId = sendId;
        }

        public String getNickName() {
            return this.nickName;
        }

        public void setNickName(String nickName) {
            this.nickName = nickName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public VssMessageChatData getContent() {
            return this.content;
        }

        public void setContent(VssMessageChatData content) {
            this.content = content;
        }

        public String getShowTime() {
            return this.showTime;
        }

        public void setShowTime(String showTime) {
            this.showTime = showTime;
        }

        public String getSendTime() {
            return this.sendTime;
        }

        public void setSendTime(String sendTime) {
            this.sendTime = sendTime;
        }

        public String getClient() {
            return this.client;
        }

        public void setClient(String client) {
            this.client = client;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String getMsgId() {
            return this.msgId;
        }

        public void setMsgId(String msgId) {
            this.msgId = msgId;
        }

        public String getChannel() {
            return this.channel;
        }

        public void setChannel(String channel) {
            this.channel = channel;
        }

        public boolean isIsHistoryMsg() {
            return this.isHistoryMsg;
        }

        public void setIsHistoryMsg(boolean isHistoryMsg) {
            this.isHistoryMsg = isHistoryMsg;
        }

        public List<?> getReplyMsg() {
            return this.replyMsg;
        }

        public void setReplyMsg(List<?> replyMsg) {
            this.replyMsg = replyMsg;
        }

        public List<?> getAtList() {
            return this.atList;
        }

        public void setAtList(List<?> atList) {
            this.atList = atList;
        }
    }

    public static class RoleNameTextBean
    implements Serializable {
        public String text;
        public String type;

        public RoleNameTextBean(String json) {
            try {
                JSONObject jsonObject = new JSONObject(json);
                this.text = jsonObject.optString("text");
                this.type = jsonObject.optString("type");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }
}

