/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.vss.api;

import android.text.TextUtils;
import com.vhall.appui.baselib.net.CloudHttpManager;
import com.vhall.appui.baselib.vss.api.VssApiConstant;
import com.vhall.appui.baselib.vss.api.VssApiRx;
import com.vhall.httpclient.utils.OKHttpUtils;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.fastjson.FastJsonConverterFactory;

public class HttpManager {
    private VssApiRx apiService;
    public static Retrofit retrofit;
    private static OkHttpClient okHttpClient;
    private static volatile HttpManager instance;

    private HttpManager() {
        this.initOkHttp();
        this.initRetrofit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpManager getInstance() {
        if (instance != null) return instance;
        Class<HttpManager> clazz = HttpManager.class;
        synchronized (HttpManager.class) {
            if (instance != null) return instance;
            instance = new HttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initOkHttp() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
        loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        builder.addInterceptor((Interceptor)loggingInterceptor);
        okHttpClient = OKHttpUtils.createOkClient();
    }

    private void initRetrofit() {
        retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(this.fixHost(VssApiConstant.API_HOST)).addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
        this.apiService = (VssApiRx)retrofit.create(VssApiRx.class);
    }

    private String fixHost(String host) {
        if (host.contains("http")) {
            return host;
        }
        return String.format("https://%s/", host);
    }

    public VssApiRx getApiService() {
        return this.apiService;
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ssfFactory;
    }

    public static FormBody getRequestBody(Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("signed_at", String.valueOf(System.currentTimeMillis() / 1000L));
        params = CloudHttpManager.getParam(params);
        if (params != null && params.size() > 0) {
            FormBody.Builder builder = new FormBody.Builder();
            for (String key : params.keySet()) {
                builder.add(key, TextUtils.isEmpty((CharSequence)params.get(key)) ? "" : params.get(key));
            }
            return builder.build();
        }
        return null;
    }

    static {
        okHttpClient = null;
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAllCerts
    implements X509TrustManager {
        private TrustAllCerts() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

