/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.content.Context;
import android.graphics.drawable.GradientDrawable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.widget.TextView;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.widget.emoji.EmojiUtils;

public class UserUtils {
    private static final String DEFAULT_NICKNAME = "\u672a\u77e5";
    public String account_id = "";
    public String nickname = "";

    public UserUtils(String account_id, String nickname) {
        this.account_id = account_id;
        this.nickname = nickname;
    }

    public static String getNickname(String nickname) {
        return TextUtils.isEmpty((CharSequence)nickname) ? DEFAULT_NICKNAME : nickname;
    }

    public static String getAvatarText(String nickname) {
        return String.valueOf(UserUtils.getNickname(nickname).charAt(0));
    }

    public static int getColor(String userid) {
        if (TextUtils.isEmpty((CharSequence)userid)) {
            return R.color.avatar_color_one;
        }
        int id2 = 0;
        try {
            id2 = Integer.parseInt(userid);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        int number = id2 % 5;
        int color2 = R.color.avatar_color_one;
        switch (number) {
            case 0: {
                color2 = R.color.avatar_color_one;
                break;
            }
            case 1: {
                color2 = R.color.avatar_color_two;
                break;
            }
            case 2: {
                color2 = R.color.avatar_color_three;
                break;
            }
            case 3: {
                color2 = R.color.avatar_color_four;
                break;
            }
        }
        return color2;
    }

    public static void setChatAvatarAndNickname(TextView avatarView, TextView contentView, String userId, String nickname, String content, Context context) {
        int color2 = UserUtils.getColor(userId);
        if (avatarView != null) {
            avatarView.setText((CharSequence)UserUtils.getAvatarText(nickname));
            GradientDrawable drawable2 = (GradientDrawable)avatarView.getBackground();
            drawable2.setColor(context.getResources().getColor(color2));
        }
        if (contentView != null) {
            String nick = UserUtils.getNickname(nickname);
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            ssb.append((CharSequence)nick);
            ssb.append((CharSequence)"  ");
            ssb.append((CharSequence)content);
            contentView.setText((CharSequence)EmojiUtils.getEmojiText(context, (CharSequence)ssb));
        }
    }

    public static void setAvatar(TextView avatarView, String userId, String nickname) {
        int color2 = UserUtils.getColor(userId);
        if (avatarView != null) {
            avatarView.setText((CharSequence)UserUtils.getAvatarText(nickname));
            GradientDrawable drawable2 = (GradientDrawable)avatarView.getBackground();
            drawable2.setColor(avatarView.getResources().getColor(color2));
        }
    }

    public static void setAvatarAndNickname(TextView avatarView, TextView nicknameView, String userId, String nickname, Context context) {
        int color2 = UserUtils.getColor(userId);
        if (avatarView != null) {
            avatarView.setText((CharSequence)UserUtils.getAvatarText(nickname));
            GradientDrawable drawable2 = (GradientDrawable)avatarView.getBackground();
            drawable2.setColor(context.getResources().getColor(color2));
        }
        if (nicknameView != null) {
            nicknameView.setText((CharSequence)UserUtils.getNickname(nickname));
            nicknameView.setTextColor(context.getResources().getColor(color2));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserUtils) {
            UserUtils userUtils = (UserUtils)obj;
            if (userUtils.account_id.equals(this.account_id)) {
                return true;
            }
        }
        return false;
    }
}

