/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import com.vhall.appui.baselib.R;

public class UiHelper {
    public static void fixStatusBar(View view) {
        int insetStatusBarHeight = UiHelper.getInsetStatusBarHeight(view.getContext().getApplicationContext());
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        lp.height += insetStatusBarHeight;
        view.setLayoutParams(lp);
        view.setPadding(0, insetStatusBarHeight, 0, 0);
    }

    public static int getInsetStatusBarHeight(Context context) {
        if (Build.VERSION.SDK_INT >= 19) {
            return UiHelper.getStatusBarHeight(context);
        }
        return 0;
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = resources.getDimensionPixelSize(resourceId);
        }
        if (result == 0) {
            result = context.getResources().getDimensionPixelSize(R.dimen.statusbar_height);
        }
        return result;
    }
}

