/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.vhall.appui.baselib.utils.VhLog;

public class TextViewUtil {
    public static void hookDecorViewClick(Context context, View decorView) {
        try {
            if (decorView instanceof ViewGroup) {
                for (int i = 0; i < ((ViewGroup)decorView).getChildCount(); ++i) {
                    View childView = ((ViewGroup)decorView).getChildAt(i);
                    if (childView instanceof ViewGroup) {
                        TextViewUtil.hookDecorViewClick(context, childView);
                        continue;
                    }
                    TextViewUtil.hookViewClick(context, childView);
                }
                TextViewUtil.hookViewClick(context, decorView);
            } else {
                TextViewUtil.hookViewClick(context, decorView);
            }
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
    }

    private static void hookViewClick(Context context, View view) {
        try {
            if (view instanceof TextView) {
                TextView textView = (TextView)view;
                if (textView.getTypeface().isBold()) {
                    Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/vh_AdihausDIN-Bold.ttf");
                    textView.setTypeface(typeface);
                } else {
                    Typeface typeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)"fonts/vh_AdihausDIN-Regular.ttf");
                    textView.setTypeface(typeface);
                }
            }
        }
        catch (Exception e) {
            VhLog.d(e.getMessage());
        }
    }
}

