/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import com.vhall.appui.baselib.utils.RomUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarUtil {
    public static int DEVICE_FIRM = -1;

    public static void transparencyBar(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(0);
            window.getDecorView().setSystemUiVisibility(1280);
        } else if (Build.VERSION.SDK_INT >= 19) {
            Window window = activity.getWindow();
            window.setFlags(0x4000000, 0x4000000);
        }
    }

    public static void setStatusBarColor(Activity activity, int colorId) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.addFlags(Integer.MIN_VALUE);
            window.setStatusBarColor(activity.getResources().getColor(colorId));
        }
    }

    private static void MIUISetStatusBarLightMode(Object object, boolean dark) {
        Window window = null;
        if (object instanceof Activity) {
            window = ((Activity)object).getWindow();
        } else if (object instanceof Window) {
            window = (Window)object;
        }
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                int darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                if (Build.VERSION.SDK_INT >= 23 && RomUtils.isMiUIV7OrAbove()) {
                    if (dark) {
                        window.getDecorView().setSystemUiVisibility(9216);
                    } else {
                        window.getDecorView().setSystemUiVisibility(1280);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void setLightStatusBar(Activity activity, boolean dark, boolean isFullMode) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (DEVICE_FIRM == -1) {
                DEVICE_FIRM = RomUtils.getLightStatusBarAvailableRomType();
            }
            switch (DEVICE_FIRM) {
                case 1: {
                    StatusBarUtil.MIUISetStatusBarLightMode(activity, dark);
                    break;
                }
                case 2: {
                    if (Build.VERSION.SDK_INT > 23) {
                        StatusBarUtil.setAndroidNativeLightStatusBar(activity, dark, isFullMode);
                        break;
                    }
                    StatusBarUtil.setFlymeLightStatusBar(activity, dark);
                    break;
                }
                case 3: {
                    StatusBarUtil.setAndroidNativeLightStatusBar(activity, dark, isFullMode);
                    break;
                }
            }
        }
    }

    @RequiresApi(api=23)
    public static void setLightStatusBar(Window window, boolean dark, boolean isFullMode) {
        if (Build.VERSION.SDK_INT >= 19) {
            switch (RomUtils.getLightStatusBarAvailableRomType()) {
                case 1: {
                    StatusBarUtil.MIUISetStatusBarLightMode(window, dark);
                    break;
                }
                case 2: {
                    if (Build.VERSION.SDK_INT > 23) {
                        StatusBarUtil.setAndroidNativeLightStatusBar(window, dark, isFullMode);
                        break;
                    }
                    StatusBarUtil.setFlymeLightStatusBar(window, dark);
                    break;
                }
                case 3: {
                    StatusBarUtil.setAndroidNativeLightStatusBar(window, dark, isFullMode);
                    break;
                }
            }
        }
    }

    private static boolean setFlymeLightStatusBar(Object obj, boolean dark) {
        boolean result = false;
        Window window = null;
        if (obj instanceof Activity) {
            window = ((Activity)obj).getWindow();
        } else if (obj instanceof Window) {
            window = (Window)obj;
        }
        if (window != null) {
            try {
                WindowManager.LayoutParams lp = window.getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                window.setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @RequiresApi(api=23)
    private static void setAndroidNativeLightStatusBar(Object obj, boolean dark, boolean isFullMode) {
        View decor = null;
        if (obj instanceof Activity) {
            decor = ((Activity)obj).getWindow().getDecorView();
        } else if (obj instanceof Window) {
            decor = ((Window)obj).getDecorView();
        }
        if (decor == null) {
            return;
        }
        if (dark) {
            if (isFullMode) {
                decor.setSystemUiVisibility(9216);
            } else {
                decor.setSystemUiVisibility(8192);
            }
        } else if (isFullMode) {
            decor.setSystemUiVisibility(1280);
        } else {
            decor.setSystemUiVisibility(256);
        }
    }

    public static int getStatusBarHeight(Context context) {
        Class<?> c = null;
        Object obj = null;
        Field field = null;
        int x = 0;
        int statusBarHeight = 0;
        try {
            c = Class.forName("com.android.internal.R$dimen");
            obj = c.newInstance();
            field = c.getField("status_bar_height");
            x = Integer.parseInt(field.get(obj).toString());
            statusBarHeight = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return statusBarHeight;
    }
}

