/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class RomUtils {
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";

    public static int getLightStatusBarAvailableRomType() {
        if (RomUtils.isFlymeV4OrAbove()) {
            return 2;
        }
        if (RomUtils.isMiUIV7OrAbove()) {
            return 3;
        }
        if (RomUtils.isMiUIV6OrAbove()) {
            return 1;
        }
        if (RomUtils.isAndroidMOrAbove()) {
            return 3;
        }
        return 4;
    }

    private static boolean isFlymeV4OrAbove() {
        String displayId = Build.DISPLAY;
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            String[] displayIdArray;
            for (String temp : displayIdArray = displayId.split(" ")) {
                if (!temp.matches("^[4-9]\\.(\\d+\\.)+\\S*")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAndroidMOrAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private static boolean isMiUIV6OrAbove() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
            String uiCode = properties.getProperty(KEY_MIUI_VERSION_CODE, null);
            if (uiCode != null) {
                int code = Integer.parseInt(uiCode);
                return code >= 4;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isMiUIV7OrAbove() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
            String uiCode = properties.getProperty(KEY_MIUI_VERSION_CODE, null);
            if (uiCode != null) {
                int code = Integer.parseInt(uiCode);
                return code >= 5;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    class AvailableRomType {
        public static final int MIUI = 1;
        public static final int FLYME = 2;
        public static final int ANDROID_NATIVE = 3;
        public static final int NA = 4;

        AvailableRomType() {
        }
    }
}

