/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Looper;
import android.widget.Toast;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.vss.utils.handler.WeakHandler;

public class NetworkConnectionDetectorUtils {
    public static boolean isConnectingToInternet(final Context context) {
        NetworkInfo[] info;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 21) {
            Network[] networks;
            for (Network mNetwork : networks = connectivityManager.getAllNetworks()) {
                NetworkInfo networkInfo = connectivityManager.getNetworkInfo(mNetwork);
                if (!networkInfo.getState().equals((Object)NetworkInfo.State.CONNECTED)) continue;
                return true;
            }
        } else if (connectivityManager != null && (info = connectivityManager.getAllNetworkInfo()) != null) {
            for (NetworkInfo anInfo : info) {
                if (anInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        new WeakHandler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)context, (int)R.string.network_error, (int)0).show();
            }
        });
        return false;
    }
}

