/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.os.Environment;
import android.os.Process;
import android.util.Log;
import java.io.File;

public class LogUtils {
    private static final String a = "VHALL";
    private static boolean logEnable = false;

    public static void setEnable(boolean enable) {
        logEnable = enable;
        if (new File(Environment.getExternalStorageDirectory(), "vhallTest").exists()) {
            logEnable = true;
        }
    }

    public static void v(String tag, String msg) {
        if (logEnable) {
            Log.v((String)a, (String)LogUtils.formatLog(tag, msg));
        }
    }

    public static void i(String tag, String msg) {
        if (logEnable) {
            Log.i((String)a, (String)LogUtils.formatLog(tag, msg));
        }
    }

    public static void w(String tag, String msg) {
        if (logEnable) {
            Log.w((String)a, (String)LogUtils.formatLog(tag, msg));
        }
    }

    public static void d(String tag, String msg) {
        if (logEnable) {
            Log.d((String)a, (String)LogUtils.formatLog(tag, msg));
        }
    }

    public static void e(String tag, String msg) {
        if (logEnable) {
            Log.e((String)a, (String)LogUtils.formatLog(tag, msg));
        }
    }

    public static void e(String msg) {
        LogUtils.e("%s", msg);
    }

    private static String formatLog(String tag, String msg) {
        return String.format("%s_pid%s  %s", tag, Process.myPid(), msg);
    }
}

