/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class ListUtils {
    public static final String DEFAULT_JOIN_SEPARATOR = ",";

    private ListUtils() {
        throw new AssertionError();
    }

    public static <V> int getSize(List<V> sourceList) {
        return sourceList == null ? 0 : sourceList.size();
    }

    public static <V> boolean isEmpty(List<V> sourceList) {
        return sourceList == null || sourceList.size() == 0;
    }

    public static String join(List<String> list) {
        return ListUtils.join(list, DEFAULT_JOIN_SEPARATOR);
    }

    public static String join(List<String> list, char separator) {
        return ListUtils.join(list, new String(new char[]{separator}));
    }

    public static String join(List<String> list, String separator) {
        return list == null ? "" : TextUtils.join((CharSequence)separator, list);
    }

    public static <V> boolean addDistinctEntry(List<V> sourceList, V entry) {
        return sourceList != null && !sourceList.contains(entry) ? sourceList.add(entry) : false;
    }

    public static <V> int addDistinctList(List<V> sourceList, List<V> entryList) {
        if (sourceList == null || ListUtils.isEmpty(entryList)) {
            return 0;
        }
        int sourceCount = sourceList.size();
        for (V entry : entryList) {
            if (sourceList.contains(entry)) continue;
            sourceList.add(entry);
        }
        return sourceList.size() - sourceCount;
    }

    public static <V> int distinctList(List<V> sourceList) {
        if (ListUtils.isEmpty(sourceList)) {
            return 0;
        }
        int sourceCount = sourceList.size();
        int sourceListSize = sourceList.size();
        for (int i = 0; i < sourceListSize; ++i) {
            for (int j = i + 1; j < sourceListSize; ++j) {
                if (!sourceList.get(i).equals(sourceList.get(j))) continue;
                sourceList.remove(j);
                sourceListSize = sourceList.size();
                --j;
            }
        }
        return sourceCount - sourceList.size();
    }

    public static <V> boolean addListNotNullValue(List<V> sourceList, V value) {
        return sourceList != null && value != null ? sourceList.add(value) : false;
    }

    public static <V> List<V> invertList(List<V> sourceList) {
        if (ListUtils.isEmpty(sourceList)) {
            return sourceList;
        }
        ArrayList<V> invertList = new ArrayList<V>(sourceList.size());
        for (int i = sourceList.size() - 1; i >= 0; --i) {
            invertList.add(sourceList.get(i));
        }
        return invertList;
    }
}

