/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import java.lang.reflect.Method;

public class KeyboardManager
implements ViewTreeObserver.OnGlobalLayoutListener {
    private static final String TAG = "KeyboardManager";
    public static final int MIN_KEYBOARD_HEIGHT = 100;
    private KeyboardListener mKeyboardListener;
    private boolean mShowFlag = false;
    private Window mWindow;
    private View mContentView;

    public void setKeyboardListener(KeyboardListener keyboardListener) {
        this.mKeyboardListener = keyboardListener;
    }

    public static KeyboardManager create(Activity activity) {
        return new KeyboardManager(activity);
    }

    public static KeyboardManager create(Dialog dialog) {
        return new KeyboardManager(dialog);
    }

    private KeyboardManager(Object contextObj) {
        if (contextObj == null) {
            Log.d((String)TAG, (String)"contextObj is null");
            return;
        }
        if (contextObj instanceof Activity) {
            this.mContentView = this.findContentView((Activity)contextObj);
            this.mWindow = ((Activity)contextObj).getWindow();
        } else if (contextObj instanceof Dialog) {
            this.mContentView = this.findContentView((Dialog)contextObj);
            this.mWindow = ((Dialog)contextObj).getWindow();
        }
        if (this.mContentView != null && this.mWindow != null) {
            this.addContentTreeObserver();
        }
    }

    private View findContentView(Activity contextObj) {
        return contextObj.findViewById(0x1020002);
    }

    private View findContentView(Dialog contextObj) {
        return contextObj.findViewById(0x1020002);
    }

    private void addContentTreeObserver() {
        this.mContentView.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public void onGlobalLayout() {
        if (this.mContentView == null || this.mWindow == null) {
            return;
        }
        int currentViewHeight = this.mContentView.getHeight();
        if (currentViewHeight == 0) {
            Log.d((String)TAG, (String)"currHeight is 0");
            return;
        }
        int screenHeight = this.getScreenHeight();
        Rect rect = new Rect();
        this.mWindow.getDecorView().getWindowVisibleDisplayFrame(rect);
        int windowBottom = rect.bottom;
        int keyboardHeight = screenHeight - windowBottom;
        Log.d((String)TAG, (String)("onGlobalLayout() called  screenHeight " + screenHeight + " keyboardHeight " + keyboardHeight + " VisibleDisplayHeight " + windowBottom));
        if (this.mKeyboardListener != null) {
            boolean currentShow;
            boolean bl = currentShow = keyboardHeight > 100;
            if (this.mShowFlag != currentShow) {
                this.mShowFlag = currentShow;
                this.mKeyboardListener.onKeyboardChange(currentShow, keyboardHeight);
            }
        }
    }

    private int getScreenHeight() {
        Display defaultDisplay = this.mWindow.getWindowManager().getDefaultDisplay();
        Point point = new Point();
        defaultDisplay.getSize(point);
        int screenHeight = point.y;
        return screenHeight;
    }

    public static boolean hasVirtualButton(Context context) {
        Resources res = context.getResources();
        int resourceId = res.getIdentifier("config_showNavigationBar", "bool", "android");
        if (resourceId != 0) {
            boolean hasVirtral = res.getBoolean(resourceId);
            String navBarOverride = KeyboardManager.getNavBarOverride();
            if (navBarOverride.equals(1)) {
                hasVirtral = false;
            } else if (navBarOverride.equals(0)) {
                hasVirtral = true;
            }
            return hasVirtral;
        }
        return !ViewConfiguration.get((Context)context).hasPermanentMenuKey();
    }

    private static String getNavBarOverride() {
        String sNavBarOverride = null;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                Class<?> c = Class.forName("android.os.SystemProperties");
                Method m = c.getDeclaredMethod("get", String.class);
                m.setAccessible(true);
                sNavBarOverride = (String)m.invoke(null, "qemu.hw.mainkeys");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sNavBarOverride;
    }

    public static void showKeyboard(final EditText view, Activity activity) {
        view.setVisibility(0);
        final InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (imm != null) {
            view.postDelayed(new Runnable(){

                @Override
                public void run() {
                    view.requestFocus();
                    imm.showSoftInput((View)view, 0);
                }
            }, 100L);
        }
    }

    public static void hintKeyboard(final View view, Context activity) {
        if (view == null) {
            return;
        }
        final InputMethodManager imm = (InputMethodManager)activity.getSystemService("input_method");
        if (imm != null) {
            view.post(new Runnable(){

                @Override
                public void run() {
                    imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
                }
            });
        }
    }

    public void destroy() {
        if (this.mContentView != null && Build.VERSION.SDK_INT >= 16) {
            this.mContentView.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
    }

    public static interface KeyboardListener {
        public void onKeyboardChange(boolean var1, int var2);
    }
}

