/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;

public class JsonParseUtil {
    private static Gson gson = null;

    private JsonParseUtil() {
    }

    public static String objToJsonString(Object object) {
        String jsonString = null;
        if (gson != null) {
            jsonString = gson.toJson(object);
        }
        return jsonString;
    }

    public static <T> T jsonStringToBean(String jsonString, Class<T> cls) {
        Object t = null;
        try {
            if (gson != null) {
                t = gson.fromJson(jsonString, cls);
            }
            return (T)t;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> List<T> jsonStringToList(String jsonString, Class<T> cls) {
        List list = null;
        if (gson != null) {
            list = (List)gson.fromJson(jsonString, new TypeToken<List<T>>(){}.getType());
        }
        return list;
    }

    public static <T> List<Map<String, T>> jsonToListMaps(String jsonString) {
        List list = null;
        if (gson != null) {
            list = (List)gson.fromJson(jsonString, new TypeToken<List<Map<String, T>>>(){}.getType());
        }
        return list;
    }

    public static <T> Map<String, T> jsonToMaps(String jsonString) {
        Map map = null;
        if (gson != null) {
            map = (Map)gson.fromJson(jsonString, new TypeToken<Map<String, T>>(){}.getType());
        }
        return map;
    }

    public static Gson getGson() {
        return gson;
    }

    static {
        if (gson == null) {
            gson = new Gson();
        }
    }
}

