/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.utils.VHToast;
import com.vhall.appui.baselib.vss.api.VssApiConstant;
import com.vhall.appui.baselib.vss.data.EnumRoleName;
import com.vhall.appui.baselib.widget.StreamItem;
import com.vhall.vhallrtc.client.VHRenderView;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class InternalUtils {
    public static boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static boolean isNetworkConnected(Context context) {
        ConnectivityManager mConnectivityManager;
        NetworkInfo mNetworkInfo;
        if (context != null && (mNetworkInfo = (mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null) {
            return mNetworkInfo.isAvailable();
        }
        return false;
    }

    public static String processImageUrl(String uri) {
        if (!TextUtils.isEmpty((CharSequence)uri) && !uri.contains("http")) {
            return String.format("%s%s", VssApiConstant.API_HOST, uri);
        }
        return uri;
    }

    public static boolean isNotEmpty(List objects) {
        return objects != null && objects.size() > 0;
    }

    public static boolean isNotEmpty(Map map) {
        return map != null && map.size() > 0;
    }

    public static <V> boolean isEmpty(List<V> sourceList) {
        return sourceList == null || sourceList.size() == 0;
    }

    public static boolean convertBoolean(String val) {
        return TextUtils.equals((CharSequence)"1", (CharSequence)val);
    }

    public static boolean convertBoolean(int val) {
        return val == 1;
    }

    public static String booleanConvertToIntStr(boolean val) {
        if (val) {
            return "1";
        }
        return "0";
    }

    public static int booleanConvertToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    public static String reverseBooleanStr(String val) {
        if (TextUtils.equals((CharSequence)"1", (CharSequence)val)) {
            return "0";
        }
        return "1";
    }

    public static String reverseBooleanStr(int val) {
        if (1 == val) {
            return "0";
        }
        return "1";
    }

    public static <T> List<List<T>> splitList(List<T> list, int length) {
        ArrayList<List<T>> results = new ArrayList<List<T>>();
        for (int i = 0; i < list.size(); i += length) {
            results.add(list.subList(i, Math.min(i + length, list.size())));
        }
        return results;
    }

    public static long stringConvertLongTime(String date) {
        return InternalUtils.stringToDate(date).getTime();
    }

    public static long timeDifference(String date1, String date2) {
        return InternalUtils.stringToDate(date1).getTime() - InternalUtils.stringToDate(date2).getTime();
    }

    public static Date stringToDate(String date) {
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return formatter.parse(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static String formatDate(String stringDate, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        Date date = InternalUtils.stringToDate(stringDate);
        return formatter.format(date);
    }

    public static long parseDays(long millisUntilFinished) {
        long days = millisUntilFinished / 86400000L;
        return days;
    }

    public static long parseInDayHours(long millisUntilFinished) {
        long hours = millisUntilFinished % 86400000L / 3600000L;
        return hours;
    }

    public static long parseHours(long millisUntilFinished) {
        long hours = millisUntilFinished / 3600000L;
        return hours;
    }

    public static long parseMinutes(long millisUntilFinished) {
        long minutes = millisUntilFinished % 3600000L / 60000L;
        return minutes;
    }

    public static long parseSeconds(long millisUntilFinished) {
        long seconds = millisUntilFinished % 60000L / 1000L;
        return seconds;
    }

    public static int getColorStr(EnumRoleName roleName) {
        if (roleName != null) {
            switch (roleName) {
                case host: {
                    return Color.parseColor((String)"#cc1E90FF");
                }
                case guest: {
                    return Color.parseColor((String)"#ccF0BE1C");
                }
                case assistant: {
                    return Color.parseColor((String)"#cc1AD5CE");
                }
            }
        }
        return Color.parseColor((String)"#cc1AD5CE");
    }

    public static int getRoleDrawableBg(EnumRoleName roleName) {
        if (roleName != null) {
            switch (roleName) {
                case host: {
                    return R.style.role_name_host;
                }
                case guest: {
                    return R.style.role_name_guest;
                }
                case assistant: {
                    return R.style.role_name_assistant;
                }
            }
        }
        return R.style.role_name_assistant;
    }

    public static String getRoleNameStr(String roleName) {
        EnumRoleName enumRoleName = EnumRoleName.getRole(roleName);
        if (enumRoleName == null || enumRoleName == EnumRoleName.viewer) {
            return "";
        }
        return enumRoleName.getName();
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String imageToBase64(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        FileInputStream is = null;
        String result = null;
        try {
            is = new FileInputStream(path);
            byte[] data = new byte[((InputStream)is).available()];
            ((InputStream)is).read(data);
            result = Base64.encodeToString((byte[])data, (int)2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static void setMaxLength(int length, TextView textView, String string2) {
        String result = string2;
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.length() > length) {
            result = String.format("%s...", string2.substring(0, length));
        }
        textView.setText((CharSequence)result);
    }

    public static String getLimitString(int length, String string2) {
        String result = string2;
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.length() > length) {
            result = String.format("%s...", string2.substring(0, length));
        }
        return result;
    }

    public static boolean getPushPermission(int requestCode, AppCompatActivity activity) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        if (activity.checkSelfPermission("android.permission.CAMERA") == 0 && activity.checkSelfPermission("android.permission.RECORD_AUDIO") == 0 && activity.checkSelfPermission("android.permission.MODIFY_AUDIO_SETTINGS") == 0) {
            return true;
        }
        VHToast.showShortToast((Context)M.context, R.string.base_please_open_camera_permission);
        activity.requestPermissions(new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO", "android.permission.MODIFY_AUDIO_SETTINGS"}, requestCode);
        return false;
    }

    public static void releaseVHRenderView(VHRenderView vhRenderView) {
        try {
            if (vhRenderView != null) {
                if (vhRenderView.stream != null) {
                    vhRenderView.stream.removeRenderView(vhRenderView);
                }
                vhRenderView.release();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void releaseVHRenderView(StreamItem item) {
        if (item != null) {
            item.release();
        }
    }

    public static void launchActivity(Context context, Bundle bundle, Class<? extends Activity> clz) {
        Intent intent = new Intent(context, clz);
        if (!(context instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        intent.putExtra("extra", bundle);
        context.startActivity(intent);
    }

    public static int strToInt(String val) {
        if (!TextUtils.isEmpty((CharSequence)val) && TextUtils.isDigitsOnly((CharSequence)val)) {
            return Integer.valueOf(val);
        }
        return 0;
    }

    public static String switchToStrNumber(int val) {
        return String.valueOf(val);
    }

    public static String switchToStrNumber(Integer val) {
        if (val == null) {
            return "0";
        }
        return String.valueOf(val);
    }

    public static String switchToStrNumber(String val) {
        if (TextUtils.isEmpty((CharSequence)val) || !TextUtils.isDigitsOnly((CharSequence)val)) {
            return "0";
        }
        return String.valueOf(val);
    }

    public static void hideSoftKeyboard(Context context, View ... viewList) {
        if (viewList == null) {
            return;
        }
        InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
        for (View v : viewList) {
            inputMethodManager.hideSoftInputFromWindow(v.getWindowToken(), 2);
        }
    }

    public static String getDateCurrentStr() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(new Date());
    }

    public static String separatorPrice(String price) {
        return InternalUtils.separatorPrice(price, ",");
    }

    public static String separatorPrice(String price, String separator) {
        String integer;
        if (TextUtils.isEmpty((CharSequence)price)) {
            return price;
        }
        String decimals = "";
        if (price.contains(".")) {
            String[] split = price.split("[.]");
            if (split == null || split.length != 2) {
                return price;
            }
            integer = split[0];
            decimals = split[1];
        } else {
            integer = price;
        }
        if (integer.length() <= 3) {
            return TextUtils.isEmpty((CharSequence)decimals) ? integer : integer + "." + decimals;
        }
        String text = "";
        for (int i = 0; i < integer.length(); ++i) {
            char c = integer.charAt(integer.length() - i - 1);
            text = i != 0 && i % 3 == 0 ? c + separator + text : c + text;
        }
        return TextUtils.isEmpty((CharSequence)decimals) ? text : text + "." + decimals;
    }
}

