/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;

public class DrawableUtils {
    public static Drawable getDrawable(int fillColor, int strokeColor, int strokeWidth, int roundRadius) {
        StateListDrawable drawable2 = new StateListDrawable();
        GradientDrawable gd = new GradientDrawable();
        gd.setColor(fillColor);
        gd.setCornerRadius((float)roundRadius);
        gd.setStroke(strokeWidth, strokeColor);
        drawable2.addState(new int[]{-16842912}, (Drawable)gd);
        return drawable2;
    }

    public static Drawable getDrawable(int fillColor, int roundRadius) {
        return DrawableUtils.getDrawable(fillColor, fillColor, 0, roundRadius);
    }

    public static Drawable getPressShape(int fillColor, int strokeColor, int strokeWidth, float[] radii, int pressedColor) {
        StateListDrawable drawable2 = new StateListDrawable();
        GradientDrawable unchecked = new GradientDrawable();
        unchecked.setColor(fillColor);
        unchecked.setCornerRadii(radii);
        unchecked.setStroke(strokeWidth, strokeColor);
        GradientDrawable checked = new GradientDrawable();
        checked.setColor(pressedColor);
        checked.setCornerRadii(radii);
        checked.setStroke(strokeWidth, pressedColor);
        drawable2.addState(new int[]{-16842919}, (Drawable)unchecked);
        drawable2.addState(new int[]{16842919}, (Drawable)checked);
        return drawable2;
    }

    public static Drawable getPressShape(int fillColor, float[] radii) {
        return DrawableUtils.getPressShape(fillColor, fillColor, 0, radii, fillColor);
    }

    public static SpannableStringBuilder changeString(String content, int start, int end, String rgb) {
        SpannableStringBuilder builder = new SpannableStringBuilder((CharSequence)content);
        builder.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)rgb)), start, end, 33);
        return builder;
    }

    public static Bitmap getBitmapFromView(View v) {
        Bitmap b = Bitmap.createBitmap((int)v.getWidth(), (int)v.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(b);
        v.layout(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
        Drawable bgDrawable = v.getBackground();
        if (bgDrawable != null) {
            bgDrawable.draw(c);
        } else {
            c.drawColor(-1);
        }
        v.draw(c);
        return b;
    }
}

