/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.request.RequestOptions;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.SpacesItemDecoration1;
import com.vhall.appui.baselib.callback.VhCallBack;
import com.vhall.appui.baselib.dialog.EndDialog;
import com.vhall.appui.baselib.dialog.ExitDialog;
import com.vhall.appui.baselib.service.broadcast.HomeMemberAction;
import com.vhall.appui.baselib.utils.CornerTransformUtil;
import com.vhall.appui.baselib.utils.TextViewUtil;
import com.vhall.appui.baselib.utils.UserUtils;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.ResponseRoomInfo;
import com.vhall.appui.baselib.vss.data.ResponseSignListUser;
import com.vhall.appui.baselib.widget.StreamItem;
import com.vhall.appui.lottey.LottetCodeAdapter;
import java.util.ArrayList;
import java.util.List;

public class DialogUtils {
    private static AlertDialog mDialog;

    public static Dialog showLoadingProgress(Context context, boolean cancel) {
        Dialog dialog = new Dialog(context, R.style.progress_dialog_style);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.dialog_loading_progress, null);
        TextViewUtil.hookDecorViewClick(context, view);
        dialog.setContentView(view);
        dialog.setCanceledOnTouchOutside(cancel);
        if (!((Activity)context).isDestroyed()) {
            dialog.show();
        }
        return dialog;
    }

    public static Dialog showLotteyCode(Context context, String[] split) {
        Dialog dialog = new Dialog(context, R.style.progress_dialog_style);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.lottet_code_recy, null);
        RecyclerView code_rec = (RecyclerView)view.findViewById(R.id.code_rec);
        code_rec.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < split.length; ++i) {
            strings.add(split[i] + "");
        }
        LottetCodeAdapter lottetCodeAdapter = new LottetCodeAdapter(strings);
        code_rec.addItemDecoration((RecyclerView.ItemDecoration)new SpacesItemDecoration1(18, 0));
        code_rec.setAdapter((RecyclerView.Adapter)lottetCodeAdapter);
        view.findViewById(R.id.confirm).setOnClickListener(v -> dialog.dismiss());
        dialog.setContentView(view);
        dialog.setCanceledOnTouchOutside(false);
        if (!((Activity)context).isDestroyed()) {
            dialog.show();
        }
        return dialog;
    }

    public static Dialog showAddressDialog(Context context, VhCallBack callBack) {
        Dialog dialog = new Dialog(context, R.style.progress_dialog_style);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.address_layout_dialog, null);
        TextViewUtil.hookDecorViewClick(context, view);
        view.findViewById(R.id.update_address).setOnClickListener(v -> {
            callBack.error("");
            dialog.dismiss();
        });
        view.findViewById(R.id.submit_address).setOnClickListener(v -> {
            callBack.success();
            dialog.dismiss();
        });
        dialog.setContentView(view);
        dialog.setCanceledOnTouchOutside(false);
        if (!((Activity)context).isDestroyed()) {
            dialog.show();
        }
        return dialog;
    }

    public static Dialog showAdidasDialog(Context context, String tips, String cancleTv, String confirmTv, boolean cancel, VhCallBack callBack) {
        Dialog dialog = new Dialog(context, R.style.progress_dialog_style);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.floating_dialog, null);
        TextViewUtil.hookDecorViewClick(context, view);
        ((TextView)view.findViewById(R.id.tips)).setText((CharSequence)tips);
        ((TextView)view.findViewById(R.id.close)).setText((CharSequence)cancleTv);
        ((TextView)view.findViewById(R.id.open)).setText((CharSequence)confirmTv);
        view.findViewById(R.id.close).setOnClickListener(v -> {
            callBack.error("");
            dialog.dismiss();
        });
        view.findViewById(R.id.open).setOnClickListener(v -> {
            callBack.success();
            dialog.dismiss();
        });
        dialog.setContentView(view);
        dialog.setCanceledOnTouchOutside(cancel);
        if (!((Activity)context).isDestroyed()) {
            dialog.show();
        }
        return dialog;
    }

    public static Dialog showLiveCoupons(Context context, String imgUrl, CallBack callBack) {
        if (TextUtils.isEmpty((CharSequence)imgUrl)) {
            callBack.onSuccess("");
            return null;
        }
        Dialog dialog = new Dialog(context, R.style.progress_dialog_style);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.live_coupons_dialog, null);
        TextViewUtil.hookDecorViewClick(context, view);
        ImageView coupon_img = (ImageView)view.findViewById(R.id.coupon_img);
        ((RequestBuilder)Glide.with((Context)context).load(imgUrl).dontAnimate()).apply(new RequestOptions().transforms(new Transformation[]{new CornerTransformUtil(context, 0.0f)})).into(coupon_img);
        view.findViewById(R.id.close).setOnClickListener(v -> {
            callBack.onSuccess("");
            dialog.dismiss();
        });
        dialog.setContentView(view);
        dialog.setCanceledOnTouchOutside(false);
        if (!((Activity)context).isDestroyed()) {
            dialog.show();
        }
        return dialog;
    }

    public static ExitDialog showLeaveRoom(Context context, int type, ExitDialog.OnCommitListener listener) {
        ExitDialog mExitDialog = new ExitDialog(context);
        mExitDialog.setType(type);
        mExitDialog.setListener(listener);
        mExitDialog.show();
        return mExitDialog;
    }

    public static AlertDialog showInvited(Context context, final OnAlertDialogClickListener listener) {
        if (mDialog != null && mDialog.isShowing()) {
            mDialog.dismiss();
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        mDialog = builder.setTitle((CharSequence)"\u9080\u8bf7\u4e0a\u9ea6").setMessage((CharSequence)"\u4e3b\u64ad\u9080\u8bf7\u60a8\u4e0a\u9ea6\uff0c\u662f\u5426\u540c\u610f\uff01").setNegativeButton((CharSequence)"\u62d2\u7edd", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                listener.onNegativeButton();
                mDialog.dismiss();
                mDialog = null;
            }
        }).setPositiveButton((CharSequence)"\u540c\u610f", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                listener.onPositiveButton();
                mDialog.dismiss();
                mDialog = null;
            }
        }).create();
        mDialog.show();
        return mDialog;
    }

    public static Dialog showBroadcastFinish(Context context, final View.OnClickListener listener) {
        final EndDialog mEndDialog = new EndDialog(context);
        mEndDialog.setOnExitClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                mEndDialog.dismiss();
                listener.onClick(v);
            }
        });
        mEndDialog.show();
        return mEndDialog;
    }

    public static Dialog showStreamActionDialog(Context context, StreamItem item, String ilId) {
        return null;
    }

    public static Dialog showMemberActionDialog(Context context, UserUtils userUtils, boolean isOnline, boolean isForbid, boolean isKickOut, HomeMemberAction.UserActionListener listener) {
        return null;
    }

    public static Dialog showUserSignDialog(Context context, String signId, int showTime) {
        return null;
    }

    public static Dialog showUserListSignDialog(Context context, List<ResponseSignListUser.ListBean> users) {
        return null;
    }

    public static Dialog showAdvShowDialog(Context context, ResponseRoomInfo.AdvertInfoBean advertInfoBean) {
        return null;
    }

    public static interface OnAlertDialogClickListener {
        public void onNegativeButton();

        public void onPositiveButton();
    }
}

