/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.WindowManager;

public class DensityUtils {
    public static final float DENSITY = Resources.getSystem().getDisplayMetrics().density;
    public static float sDensity = 0.0f;

    private DensityUtils() {
        throw new AssertionError();
    }

    public static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }

    public static float getDensity(Context context) {
        if (sDensity == 0.0f) {
            sDensity = DensityUtils.getDisplayMetrics((Context)context).density;
        }
        return sDensity;
    }

    public static float dpToPx(float dpValue) {
        return dpValue * DENSITY;
    }

    public static float dpToPx(Context context, float dpValue) {
        return dpValue * DensityUtils.getDensity(context);
    }

    public static float pxToDp(float pxValue) {
        return pxValue / DENSITY;
    }

    public static int dpToPxInt(float dpValue) {
        return (int)(dpValue * DENSITY + 0.5f);
    }

    public static int pxToDpInt(float pxValue) {
        return (int)(pxValue / DENSITY + 0.5f);
    }

    public static int spToPxInt(float spValue) {
        return (int)(spValue * DENSITY + 0.5f);
    }

    public static int dpToPxInt(Context context, int dp) {
        return (int)((double)(DensityUtils.getDensity(context) * (float)dp) + 0.5);
    }

    public static int pxToDpInt(Context context, int px) {
        return (int)((double)((float)px / DensityUtils.getDensity(context)) + 0.5);
    }

    public static int getScreenWidth() {
        return Resources.getSystem().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight() {
        return Resources.getSystem().getDisplayMetrics().heightPixels;
    }

    public static int getScreenWidth(Context context) {
        return DensityUtils.getDisplayMetrics((Context)context).widthPixels;
    }

    public static int getScreenHeight(Context context) {
        return DensityUtils.getDisplayMetrics((Context)context).heightPixels;
    }

    public static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }

    public static boolean isNavigationBarShow(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            Display display = ((Activity)context).getWindowManager().getDefaultDisplay();
            Point size = new Point();
            Point realSize = new Point();
            display.getSize(size);
            display.getRealSize(realSize);
            return realSize.y != size.y;
        }
        boolean menu = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean back = KeyCharacterMap.deviceHasKey((int)4);
        return !menu && !back;
    }

    public static int getNavigationBarHeight(Context context) {
        if (!DensityUtils.isNavigationBarShow(context)) {
            return 0;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static boolean hasNavigationBar() {
        if (Build.FINGERPRINT.startsWith("generic")) {
            return true;
        }
        int id2 = Resources.getSystem().getIdentifier("config_showNavigationBar", "bool", "android");
        return id2 > 0 && Resources.getSystem().getBoolean(id2);
    }

    public static void hideNavigationBar(Activity activity) {
        if (DensityUtils.hasNavigationBar()) {
            View decorView = activity.getWindow().getDecorView();
            int uiOptions = 6;
            decorView.setSystemUiVisibility(uiOptions);
        }
    }

    public static int getToolbarHeight(Context context) {
        return DensityUtils.dpToPxInt(45.0f);
    }

    public static void full(Activity activity, boolean enable) {
        if (enable) {
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.flags |= 0x400;
            activity.getWindow().setAttributes(lp);
            activity.getWindow().addFlags(512);
        } else {
            WindowManager.LayoutParams attr = activity.getWindow().getAttributes();
            attr.flags &= 0xFFFFFBFF;
            activity.getWindow().setAttributes(attr);
            activity.getWindow().clearFlags(512);
        }
    }
}

