/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.content.Context;
import android.os.Environment;
import java.io.File;
import java.math.BigDecimal;

public class DataCleanUtils {
    public static String getTotalCacheSize(Context context) throws Exception {
        long cacheSize = DataCleanUtils.getFolderSize(context.getCacheDir());
        if (Environment.getExternalStorageState().equals("mounted")) {
            cacheSize += DataCleanUtils.getFolderSize(context.getExternalCacheDir());
        }
        return DataCleanUtils.getFormatSizeMb(cacheSize);
    }

    public static void clearAllCache(Context context) {
        DataCleanUtils.deleteDir(context.getCacheDir());
        if (Environment.getExternalStorageState().equals("mounted")) {
            DataCleanUtils.deleteDir(context.getExternalCacheDir());
        }
    }

    private static boolean deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = DataCleanUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static long getFolderSize(File file) throws Exception {
        long size = 0L;
        try {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                if (fileList[i].isDirectory()) {
                    size += DataCleanUtils.getFolderSize(fileList[i]);
                    continue;
                }
                size += fileList[i].length();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return size;
    }

    public static String getFormatSizeMb(double size) {
        return String.format("%.2fM", size / 1048576.0);
    }

    public static String getFormatSize(double size) {
        double kiloByte = size / 1024.0;
        if (kiloByte < 1.0) {
            return "0K";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return result1.setScale(2, 4).toPlainString() + "K";
        }
        double gigaByte = megaByte / 1024.0;
        if (gigaByte < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
            return result2.setScale(2, 4).toPlainString() + "M";
        }
        double teraBytes = gigaByte / 1024.0;
        if (teraBytes < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(gigaByte));
            return result3.setScale(2, 4).toPlainString() + "GB";
        }
        BigDecimal result4 = new BigDecimal(teraBytes);
        return result4.setScale(2, 4).toPlainString() + "TB";
    }
}

