/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class CpuUtils {
    private static ActivityManager mActivityManager;
    static Status sStatus;

    public static synchronized ActivityManager getActivityManager(Context context) {
        if (mActivityManager == null) {
            mActivityManager = (ActivityManager)context.getSystemService("activity");
        }
        return mActivityManager;
    }

    public static float getCurProcessCpuRate() {
        float totalCpuTime1 = CpuUtils.getTotalCpuTime();
        float processCpuTime1 = CpuUtils.getAppCpuTime();
        try {
            Thread.sleep(360L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        float totalCpuTime2 = CpuUtils.getTotalCpuTime();
        float processCpuTime2 = CpuUtils.getAppCpuTime();
        if (totalCpuTime2 == 0.0f) {
            return 0.0f;
        }
        float cpuRate = 100.0f * (processCpuTime2 - processCpuTime1) / (totalCpuTime2 - totalCpuTime1);
        return cpuRate;
    }

    public static float getTotalCpuRate() {
        float totalCpuTime1 = CpuUtils.getTotalCpuTime();
        float totalUsedCpuTime1 = totalCpuTime1 - (float)CpuUtils.sStatus.idletime;
        try {
            Thread.sleep(360L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        float totalCpuTime2 = CpuUtils.getTotalCpuTime();
        float totalUsedCpuTime2 = totalCpuTime2 - (float)CpuUtils.sStatus.idletime;
        float cpuRate = 100.0f * (totalUsedCpuTime2 - totalUsedCpuTime1) / (totalCpuTime2 - totalCpuTime1);
        return cpuRate;
    }

    public static long getTotalCpuTime() {
        String[] cpuInfos = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            CpuUtils.sStatus.usertime = Long.parseLong((String)cpuInfos[2]);
            CpuUtils.sStatus.nicetime = Long.parseLong((String)cpuInfos[3]);
            CpuUtils.sStatus.systemtime = Long.parseLong(cpuInfos[4]);
            CpuUtils.sStatus.idletime = Long.parseLong(cpuInfos[5]);
            CpuUtils.sStatus.iowaittime = Long.parseLong(cpuInfos[6]);
            CpuUtils.sStatus.irqtime = Long.parseLong(cpuInfos[7]);
            CpuUtils.sStatus.softirqtime = Long.parseLong(cpuInfos[8]);
            return sStatus.getTotalTime();
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    public static long getAppCpuTime() {
        String[] cpuInfos = null;
        try {
            int pid = Process.myPid();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + pid + "/stat")), 1000);
            String load = reader.readLine();
            reader.close();
            cpuInfos = load.split(" ");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            long appCpuTime = Long.parseLong((String)cpuInfos[13]) + Long.parseLong((String)cpuInfos[14]) + Long.parseLong((String)cpuInfos[15]) + Long.parseLong((String)cpuInfos[16]);
            return appCpuTime;
        }
        catch (NullPointerException e) {
            return 0L;
        }
    }

    static {
        sStatus = new Status();
    }

    static class Status {
        public long usertime;
        public long nicetime;
        public long systemtime;
        public long idletime;
        public long iowaittime;
        public long irqtime;
        public long softirqtime;

        Status() {
        }

        public long getTotalTime() {
            return this.usertime + this.nicetime + this.systemtime + this.idletime + this.iowaittime + this.irqtime + this.softirqtime;
        }
    }
}

