/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import java.security.MessageDigest;

public class CornerTransformUtil
implements Transformation<Bitmap> {
    private BitmapPool mBitmapPool;
    private float radius;
    private boolean exceptLeftTop;
    private boolean exceptRightTop;
    private boolean exceptLeftBottom = true;
    private boolean exceptRightBotoom = true;

    public void setExceptCorner(boolean leftTop, boolean rightTop, boolean leftBottom, boolean rightBottom) {
        this.exceptLeftTop = leftTop;
        this.exceptRightTop = rightTop;
        this.exceptLeftBottom = leftBottom;
        this.exceptRightBotoom = rightBottom;
    }

    public CornerTransformUtil(Context context, float radius) {
        this.mBitmapPool = Glide.get((Context)context).getBitmapPool();
        this.radius = radius;
    }

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int outWidth, int outHeight) {
        int finalHeight;
        int finalWidth;
        Bitmap source = (Bitmap)resource.get();
        if (outWidth > outHeight) {
            float ratio = (float)outHeight / (float)outWidth;
            finalWidth = source.getWidth();
            finalHeight = (int)((float)source.getWidth() * ratio);
            if (finalHeight > source.getHeight()) {
                ratio = (float)outWidth / (float)outHeight;
                finalHeight = source.getHeight();
                finalWidth = (int)((float)source.getHeight() * ratio);
            }
        } else if (outWidth < outHeight) {
            float ratio = (float)outWidth / (float)outHeight;
            finalHeight = source.getHeight();
            finalWidth = (int)((float)source.getHeight() * ratio);
            if (finalWidth > source.getWidth()) {
                ratio = (float)outHeight / (float)outWidth;
                finalWidth = source.getWidth();
                finalHeight = (int)((float)source.getWidth() * ratio);
            }
        } else {
            finalWidth = finalHeight = source.getHeight();
        }
        this.radius *= (float)finalHeight / (float)outHeight;
        Bitmap outBitmap = this.mBitmapPool.get(finalWidth, finalHeight, Bitmap.Config.ARGB_8888);
        if (outBitmap == null) {
            outBitmap = Bitmap.createBitmap((int)finalWidth, (int)finalHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(outBitmap);
        Paint paint = new Paint();
        BitmapShader shader = new BitmapShader(source, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        int width = (source.getWidth() - finalWidth) / 2;
        int height = (source.getHeight() - finalHeight) / 2;
        if (width != 0 || height != 0) {
            Matrix matrix = new Matrix();
            matrix.setTranslate((float)(-width), (float)(-height));
            shader.setLocalMatrix(matrix);
        }
        paint.setShader((Shader)shader);
        paint.setAntiAlias(true);
        RectF rectF = new RectF(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        canvas.drawRoundRect(rectF, this.radius, this.radius, paint);
        canvas.drawRect(0.0f, (float)canvas.getHeight() - this.radius, this.radius, (float)canvas.getHeight(), paint);
        canvas.drawRect((float)canvas.getWidth() - this.radius, (float)canvas.getHeight() - this.radius, (float)canvas.getWidth(), (float)canvas.getHeight(), paint);
        return BitmapResource.obtain((Bitmap)outBitmap, (BitmapPool)this.mBitmapPool);
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
    }
}

