/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.vote;

import com.vhall.appui.baselib.CommonManager;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.utils.rxutils.BaseVhallVssHttp;
import com.vhall.framework.VhallSDK;
import java.util.HashMap;

public class VoteConstantsInternal {
    public static String createVoteUrl(String voteId, EnumVoteWEB type) {
        return VoteConstantsInternal.createVoteUrl(voteId, type.getType());
    }

    public static String createVoteUrl(String voteId, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("app_id", VhallSDK.getInstance().getAPP_ID());
        params.put("channel_id", VssRoomManager.getInstance().getRoomInfo().getChannel_id());
        params.put("paas_access_token", VssRoomManager.getInstance().getRoomInfo().getPaas_access_token());
        params.put("room_id", VssRoomManager.getInstance().getRoomInfo().getRoom_id());
        params.put("third_party_user_id", AccountManager.getInstance().getUserId());
        params.put("token", AccountManager.getInstance().getToken());
        params.put("type", type);
        params.put("vss_token", BaseVhallVssHttp.vssToken);
        String baseUrl = "";
        baseUrl = CommonManager.getInstance(M.context).getBaseConfig().getPlatform().equals("4") ? String.format("%s/mobile/vote-management/vote-embed/%s", CommonManager.getInstance(M.context).getBaseConfig().getWeb_host(), voteId) : String.format("%s/mobile/vote-embed/%s", CommonManager.getInstance(M.context).getBaseConfig().getWeb_host(), voteId);
        StringBuilder builder = new StringBuilder();
        for (String k : params.keySet()) {
            if (builder.length() == 0) {
                builder.append("?");
            } else {
                builder.append("&");
            }
            builder.append(String.format("%s=%s", k, params.get(k)));
        }
        return String.format("%s%s", baseUrl, builder.toString());
    }

    public static String getShowTime(int time) {
        String strTime = "00:00";
        if (time >= 1) {
            int minute = time / 60;
            int second = time % 60;
            String minuteStr = "";
            minuteStr = minute > 9 ? minute + ":" : "0" + minute + ":";
            strTime = second < 10 ? minuteStr + "0" + second : minuteStr + second;
        }
        return strTime;
    }

    public static enum EnumVoteWEB {
        SUBMIT("submit"),
        RESULT("result");

        private String type;

        private EnumVoteWEB(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

