/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.sensitivewords;

import com.vhall.appui.baselib.core.SimpleManager;
import com.vhall.appui.baselib.service.sensitivewords.IFilterSensitiveWordsListener;
import com.vhall.appui.baselib.service.sensitivewords.IFilterSensitiveWordsResultListener;
import com.vhall.appui.baselib.service.sensitivewords.ISensitiveWordsService;
import com.vhall.appui.baselib.utils.Singleton;

public class SensitiveWordsManager
extends SimpleManager<ISensitiveWordsService> {
    private static final Singleton<SensitiveWordsManager> ACCOUNT_MANAGER_SINGLETON = new Singleton<SensitiveWordsManager>(){

        @Override
        protected SensitiveWordsManager create() {
            return new SensitiveWordsManager();
        }
    };

    public static SensitiveWordsManager getInstance() {
        return ACCOUNT_MANAGER_SINGLETON.get();
    }

    @Override
    public String getComponentsName() {
        return "sensitive_words";
    }

    public void requestSensitiveWords() {
        if (this.service != null) {
            ((ISensitiveWordsService)this.service).requestSensitiveWords();
        }
    }

    public void filterSensitiveWords(String message, IFilterSensitiveWordsResultListener listener) {
        if (this.service != null) {
            ((ISensitiveWordsService)this.service).filterSensitiveWords(message, listener);
        } else {
            listener.onFilterResult(true, message, "");
        }
    }

    public void addOnFilterSensitiveWordsListener(IFilterSensitiveWordsListener listener) {
        if (this.service != null) {
            ((ISensitiveWordsService)this.service).addOnFilterSensitiveWordsListener(listener);
        }
    }

    public void removeFilterSensitiveWordsListener(IFilterSensitiveWordsListener listener) {
        if (this.service != null) {
            ((ISensitiveWordsService)this.service).removeFilterSensitiveWordsListener(listener);
        }
    }
}

