/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.questionanswer;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.vhall.appui.baselib.service.questionanswer.IChangeVisibilityListener;
import com.vhall.appui.baselib.service.questionanswer.IQuestionAnswer;
import com.vhall.appui.baselib.service.questionanswer.IQuestionAnswerCallBack;
import com.vhall.appui.baselib.service.questionanswer.QuestionAnswerManager;

public class IQuestionAnswerPanelView
extends RelativeLayout
implements IQuestionAnswer {
    private IQuestionAnswer proxy;

    public IQuestionAnswerPanelView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public IQuestionAnswerPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public IQuestionAnswerPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        if (QuestionAnswerManager.getInstance().isLoaded()) {
            this.proxy = QuestionAnswerManager.getInstance().createQuestionAnswerView((Activity)context);
            this.addView((View)this.proxy);
            this.proxy.setVisibilityListener(new IChangeVisibilityListener(){

                @Override
                public void viewChangeVisibility(int visibility) {
                    if (visibility == 8) {
                        IQuestionAnswerPanelView.this.setVisibility(visibility);
                    }
                }
            });
        } else {
            this.proxy = new IQuestionAnswer.SimpleDefaultQuestionAnswerView();
            super.setVisibility(8);
        }
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (visibility == 0) {
            this.proxy.changeVisibility(visibility);
        }
    }

    @Override
    public void setQuestionAnswerCallBack(IQuestionAnswerCallBack questionAnswerCallBack) {
        this.proxy.setQuestionAnswerCallBack(questionAnswerCallBack);
    }

    @Override
    public void setVisibilityListener(IChangeVisibilityListener visibilityListener) {
    }

    @Override
    public void changeVisibility(int visibility) {
    }

    @Override
    public Bundle call(String action, Bundle bundle) {
        return this.proxy.call(action, bundle);
    }
}

