/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.pictureinpicture;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import com.lzf.easyfloat.interfaces.OnPermissionResult;
import com.lzf.easyfloat.permission.PermissionUtils;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.callback.VhCallBack;
import com.vhall.appui.baselib.core.SimpleManager;
import com.vhall.appui.baselib.service.pictureinpicture.IPictureInPictureListener;
import com.vhall.appui.baselib.service.pictureinpicture.IPictureInPicturePanel;
import com.vhall.appui.baselib.service.pictureinpicture.IPictureInPictureService;
import com.vhall.appui.baselib.utils.DialogUtils;
import com.vhall.appui.baselib.utils.Singleton;

public class PictureInPictureManager
extends SimpleManager<IPictureInPictureService> {
    private static final Singleton<PictureInPictureManager> ACCOUNT_MANAGER_SINGLETON = new Singleton<PictureInPictureManager>(){

        @Override
        protected PictureInPictureManager create() {
            return new PictureInPictureManager();
        }
    };
    private Activity activity;
    boolean getFloatPermission;

    public static PictureInPictureManager getInstance() {
        return ACCOUNT_MANAGER_SINGLETON.get();
    }

    private PictureInPictureManager() {
    }

    @Override
    public String getComponentsName() {
        return "picture_in_picture_service";
    }

    public IPictureInPicturePanel showOrHidePicture(Context uiContext, AttributeSet attrs, int defStyleAttr) {
        if (this.service != null) {
            return ((IPictureInPictureService)this.service).showOrHidePicture(uiContext, attrs, defStyleAttr);
        }
        return null;
    }

    public void againFloating() {
        if (this.activity == null) {
            return;
        }
        VhSdk.getInstance().closePIPView((Context)this.activity);
        Bundle bundle = new Bundle();
        bundle.putBoolean("pause", false);
        PictureInPictureManager.getInstance().startFloating(this.activity, bundle);
    }

    public void startFloating(Activity activity, Bundle bundle) {
        this.activity = activity;
        if (null != this.service) {
            ((IPictureInPictureService)this.service).startFloating(activity, bundle);
        }
    }

    public void startVodFloating(Activity activity, Bundle bundle) {
        this.activity = activity;
        if (null != this.service) {
            ((IPictureInPictureService)this.service).startVodFloating(activity, bundle);
        }
    }

    public void stopService(Context activity) {
        if (null != this.service) {
            ((IPictureInPictureService)this.service).stopService(activity);
        }
    }

    public void checkFloatingPermission(final IPictureInPictureListener.CheckFloatPermissionCallback callback, final Activity context) {
        if (PermissionUtils.checkPermission((Context)context)) {
            callback.callback(true);
        } else {
            Log.e((String)"===requestPermission", (String)"requestPermission");
            if (this.getFloatPermission) {
                return;
            }
            DialogUtils.showAdidasDialog((Context)context, "\u76f4\u64ad\u5c0f\u7a97\u9700\u8981\u5728\u5e94\u7528\u4e2d\u8bbe\u7f6e\u5f00\u542f\u60ac\u6d6e\u6743\u9650\uff0c\u662f\u5426\u524d\u5f80\u5f00\u542f\u6743\u9650\uff1f", "\u4e0d\u5f00\u542f", "\u53bb\u5f00\u542f", false, new VhCallBack(){

                @Override
                public void success() {
                    PictureInPictureManager.this.getFloatPermission = true;
                    PermissionUtils.requestPermission((Activity)context, (OnPermissionResult)new OnPermissionResult(){

                        public void permissionResult(boolean b) {
                            PictureInPictureManager.this.getFloatPermission = false;
                            callback.callback(b);
                        }
                    });
                }

                @Override
                public void error(String message) {
                    callback.callback(false);
                }
            });
        }
    }
}

