/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.login;

import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;
import com.vhall.appui.baselib.core.SimpleManager;
import com.vhall.appui.baselib.service.login.IAccountListener;
import com.vhall.appui.baselib.service.login.IAccountService;
import com.vhall.appui.baselib.service.login.IUser;
import com.vhall.appui.baselib.utils.Singleton;
import com.vhall.appui.loginview.UserManager;
import io.reactivex.disposables.Disposable;

public final class AccountManager
extends SimpleManager<IAccountService> {
    private static final Singleton<AccountManager> ACCOUNT_MANAGER_SINGLETON = new Singleton<AccountManager>(){

        @Override
        protected AccountManager create() {
            return new AccountManager();
        }
    };

    public static AccountManager getInstance() {
        return ACCOUNT_MANAGER_SINGLETON.get();
    }

    @Override
    public String getComponentsName() {
        return "login";
    }

    public void startLogin(Context activity, Bundle bundle) {
        if (null != this.service) {
            ((IAccountService)this.service).startLogin(activity, bundle);
        }
    }

    public View loginView(Context activity, Bundle bundle) {
        if (null != this.service) {
            return ((IAccountService)this.service).loginView(activity, bundle);
        }
        return new TextView(activity);
    }

    public String getUserId() {
        if (null != this.service) {
            return ((IAccountService)this.service).getUserId();
        }
        return UserManager.getUserId();
    }

    public String getAvatar() {
        if (null != this.service) {
            return ((IAccountService)this.service).getAvatar();
        }
        return null;
    }

    public boolean isLogin() {
        if (null != this.service) {
            return ((IAccountService)this.service).isLogin();
        }
        return false;
    }

    public String getToken() {
        if (null != this.service) {
            return ((IAccountService)this.service).getToken();
        }
        return UserManager.getUserToken();
    }

    public String getNickName() {
        if (null != this.service) {
            return ((IAccountService)this.service).getNickName();
        }
        return UserManager.getNickname();
    }

    public void logOut(Bundle bundle) {
        if (null != this.service) {
            ((IAccountService)this.service).logOut(bundle);
        }
    }

    public Disposable logOutByNet(Bundle bundle) {
        if (null != this.service) {
            return ((IAccountService)this.service).logOutByNet(bundle);
        }
        return null;
    }

    public void refreshUser(IUser iUser) {
        if (null != this.service) {
            ((IAccountService)this.service).refreshUser(iUser);
        }
    }

    public IUser getUser() {
        if (null != this.service) {
            return ((IAccountService)this.service).getUser();
        }
        return null;
    }

    public void unRegisterListener(IAccountListener listener) {
        if (null != this.service) {
            ((IAccountService)this.service).unRegisterListener(listener);
        }
    }

    public void addAccountListener(IAccountListener listener) {
        if (null != this.service) {
            ((IAccountService)this.service).addAccountListener(listener);
        }
    }
}

