/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.like;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Point;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.vhall.appui.baselib.R;
import com.vhall.appui.baselib.service.like.IPressLikeView;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class PressLikeView
extends ViewGroup
implements IPressLikeView {
    private List<String> imageUrls;
    private List<Integer> imageResources;
    private List<Interpolator> inters;
    private Random random;
    private int defaultSize = 80;
    private int mLikeNum = 0;
    Handler handler = new Handler();
    Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (PressLikeView.this.mLikeNum <= 0) {
                PressLikeView.this.handler.removeCallbacks(PressLikeView.this.runnable);
            } else {
                PressLikeView.this.showResource();
                PressLikeView.this.handler.postDelayed((Runnable)this, 200L);
            }
            --PressLikeView.this.mLikeNum;
        }
    };

    public PressLikeView(Context context) {
        super(context);
        this.initData();
    }

    public PressLikeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initData();
    }

    public PressLikeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initData();
    }

    private void initData() {
        this.random = new Random();
        this.imageUrls = new ArrayList<String>();
        this.inters = new ArrayList<Interpolator>();
        this.inters.add((Interpolator)new LinearInterpolator());
        this.inters.add((Interpolator)new AccelerateInterpolator());
        this.inters.add((Interpolator)new AccelerateDecelerateInterpolator());
        this.inters.add((Interpolator)new DecelerateInterpolator());
        this.imageUrls = new ArrayList<String>();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    @Override
    public void setImageUrls(List<String> imageUrls) {
        this.imageUrls.clear();
        this.imageUrls = imageUrls;
    }

    @Override
    public void setImageResources(List<Integer> imageUrls) {
        this.imageResources = imageUrls;
    }

    @Override
    public void setDefaultSize(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    @Override
    public void show() {
        this.show(null);
    }

    @Override
    public void show(int num) {
        this.mLikeNum = Math.min(num, 10);
        this.handler.postDelayed(this.runnable, 300L);
        this.setVisibility(0);
    }

    @Override
    public void release() {
        if (this.handler != null) {
            this.handler.removeCallbacks(this.runnable);
            this.handler = null;
        }
    }

    @Override
    public void show(String imageUrl) {
        ImageView view = new ImageView(this.getContext());
        view.setLayoutParams(new ViewGroup.LayoutParams(this.defaultSize, this.defaultSize));
        if (this.imageResources == null && this.imageResources.size() > 0) {
            imageUrl = this.imageUrls.get(this.random.nextInt(this.imageUrls.size()));
        }
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Context)this.getContext()).load(imageUrl).placeholder(R.drawable.icon_live_heart)).error(R.drawable.icon_live_heart)).override(this.defaultSize, this.defaultSize)).fitCenter()).diskCacheStrategy(DiskCacheStrategy.ALL)).into(view);
        this.addView((View)view);
        view.layout(this.getMeasuredWidth() / 2 - this.defaultSize, (int)((double)this.getMeasuredHeight() - (double)this.defaultSize * 1.5), this.getMeasuredWidth() / 2, (int)((double)this.getMeasuredHeight() - 0.5 * (double)this.defaultSize));
        this.startAnim(view);
    }

    public void showResource() {
        ImageView view = new ImageView(this.getContext());
        view.setLayoutParams(new ViewGroup.LayoutParams(this.defaultSize, this.defaultSize));
        int imageUrl = R.drawable.icon_live_heart;
        if (this.imageResources != null && this.imageResources.size() > 0) {
            imageUrl = this.imageResources.get(this.random.nextInt(this.imageResources.size()));
        }
        view.setImageResource(imageUrl);
        this.addView((View)view);
        view.layout(this.getMeasuredWidth() / 2 - this.defaultSize, (int)((double)this.getMeasuredHeight() - (double)this.defaultSize * 1.5), this.getMeasuredWidth() / 2, (int)((double)this.getMeasuredHeight() - 0.5 * (double)this.defaultSize));
        this.startAnim(view);
    }

    private void startAnim(final ImageView view) {
        AnimatorSet animatorSet = new AnimatorSet();
        ValueAnimator inAnim = ValueAnimator.ofFloat((float[])new float[]{0.5f, 1.0f});
        inAnim.setDuration(500L);
        inAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                view.setAlpha(value);
                view.setScaleX(value);
                view.setY(value);
            }
        });
        ValueAnimator outAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        outAnim.setDuration(1200L);
        outAnim.setStartDelay(1200L);
        outAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                view.setAlpha(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        int width = this.getMeasuredWidth() <= 0 ? 100 : this.getMeasuredWidth();
        int height = this.getMeasuredHeight() <= 0 ? 100 : this.getMeasuredHeight();
        ValueAnimator transAnim = ValueAnimator.ofObject((TypeEvaluator)new BezierValue(), (Object[])new Object[]{new Point(width / 2 - this.defaultSize / 6, height), new Point(new Random().nextInt(width), 0)});
        transAnim.setDuration(3000L);
        transAnim.setInterpolator((TimeInterpolator)this.inters.get(this.random.nextInt(this.inters.size())));
        transAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Point point = (Point)animation.getAnimatedValue();
                view.setX((float)point.x);
                view.setY((float)point.y);
            }
        });
        animatorSet.playTogether(new Animator[]{inAnim, transAnim, outAnim});
        animatorSet.start();
        animatorSet.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                PressLikeView.this.removeView((View)view);
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
    }

    class BezierValue
    implements TypeEvaluator<Point> {
        private Random random = new Random();
        private int ctrlPX1;
        private int ctrlPX2;
        private int ctrlPY1;
        private int ctrlPY2;
        private boolean isInit;

        BezierValue() {
        }

        public Point evaluate(float fraction, Point startValue, Point endValue) {
            Point point = new Point();
            point.x = (int)this.cubicPointX(fraction, startValue.x, endValue.x);
            point.y = (int)this.cubicPointY(fraction, startValue.y, endValue.y);
            return point;
        }

        private double cubicPointX(float fraction, int start, int end) {
            if (!this.isInit) {
                this.ctrlPY1 = this.random.nextInt(start + end / 2);
                this.ctrlPY2 = this.random.nextInt(start + end / 2) + (start + end / 2);
                if (this.random.nextBoolean()) {
                    this.ctrlPX1 = (int)((float)this.random.nextInt(start) - (float)start / 4.0f);
                    this.ctrlPX2 = (int)((float)this.random.nextInt(start) + (float)start * 1.25f);
                } else {
                    this.ctrlPX1 = (int)((float)this.random.nextInt(start) + (float)start * 1.25f);
                    this.ctrlPX2 = (int)((float)this.random.nextInt(start) - (float)start / 4.0f);
                }
                this.isInit = true;
            }
            return (double)start * Math.pow(1.0f - fraction, 3.0) + (double)((float)(3 * this.ctrlPX1) * fraction) * Math.pow(1.0f - fraction, 2.0) + (double)(3 * this.ctrlPX2) * Math.pow(fraction, 2.0) * (double)(1.0f - fraction) + (double)end * Math.pow(fraction, 3.0);
        }

        private double cubicPointY(float fraction, int start, int end) {
            return (double)start * Math.pow(1.0f - fraction, 3.0) + (double)((float)(3 * this.ctrlPY1) * fraction) * Math.pow(1.0f - fraction, 2.0) + (double)(3 * this.ctrlPY2) * Math.pow(fraction, 2.0) * (double)(1.0f - fraction) + (double)end * Math.pow(fraction, 3.0);
        }
    }
}

