/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.language;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.service.language.LanguageData;
import com.vhall.appui.baselib.utils.VHToast;
import java.util.Locale;

public class LanguageManager {
    public static LanguageData languageData;
    public static String systemLanguage;

    public static void onCreate(Context context, String defLanguage_type) {
        languageData = LanguageData.getFromLocal(context, defLanguage_type);
        systemLanguage = LanguageData.getSystemLanguage(context);
    }

    public static String getLanguage_text() {
        return languageData == null ? "" : LanguageManager.languageData.language_text;
    }

    public static String getNowChooseLanguage() {
        return languageData == null ? "def" : LanguageManager.languageData.nowChooseLanguage;
    }

    public static String getLanguage_type() {
        return languageData == null ? "zh" : LanguageManager.languageData.language_type;
    }

    public static String getSystemLanguage() {
        return systemLanguage == null ? "zh" : systemLanguage;
    }

    public static Context changeLanguage(Context mContext, String language, String country) {
        Resources res = mContext.getResources();
        Configuration config = res.getConfiguration();
        DisplayMetrics metrics = res.getDisplayMetrics();
        try {
            Locale loc = !TextUtils.isEmpty((CharSequence)language) && !TextUtils.equals((CharSequence)"def", (CharSequence)language) ? (TextUtils.isEmpty((CharSequence)country) ? new Locale(language) : new Locale(language, country)) : new Locale(LanguageManager.getSystemLanguage());
            config.setLocale(loc);
            if (Build.VERSION.SDK_INT >= 24) {
                res.updateConfiguration(config, metrics);
                mContext.createConfigurationContext(config);
                return mContext;
            }
            mContext.getResources().updateConfiguration(config, metrics);
        }
        catch (Exception e) {
            e.printStackTrace();
            VHToast.showShortToast("error language");
        }
        return mContext;
    }

    public static Context changeLanguage(Context mContext, String language) {
        return LanguageManager.changeLanguage(mContext, language, "");
    }

    public static void refreshLanguage(Context mContext, LanguageData data) {
        if (languageData == null || mContext == null) {
            return;
        }
        languageData = data;
        LanguageData.saveToLocal(languageData, mContext);
    }

    public static Context attachBaseContext(Context context) {
        String language = LanguageManager.initLanguage();
        if (TextUtils.isEmpty((CharSequence)language)) {
            return context;
        }
        return LanguageManager.changeLanguage(context, language);
    }

    private static String initLanguage() {
        String language = LanguageManager.getLanguage_type();
        if (TextUtils.isEmpty((CharSequence)language)) {
            return null;
        }
        if (!TextUtils.isEmpty((CharSequence)language) && !language.contains(",")) {
            return language;
        }
        if (!TextUtils.isEmpty((CharSequence)LanguageManager.getNowChooseLanguage())) {
            return LanguageManager.getNowChooseLanguage();
        }
        return null;
    }

    public static String getStringId(String name) {
        if (M.context == null) {
            return null;
        }
        int id2 = M.context.getResources().getIdentifier(name, "string", M.context.getPackageName());
        try {
            String value = M.context.getString(id2);
            if (TextUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

