/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.language;

import android.content.Context;
import android.content.SharedPreferences;

public class LanguageData {
    public String language_type;
    public String language_text;
    public String nowChooseLanguage;
    public String systemLanguage;

    public String getLanguage_text() {
        return this.language_text;
    }

    public String getNowChooseLanguage() {
        return this.nowChooseLanguage;
    }

    public String getLanguage_type() {
        return this.language_type;
    }

    public void setLanguage_type(String language_type) {
        this.language_type = language_type;
    }

    public LanguageData(String language_text, String nowChooseLanguage) {
        this.language_text = language_text;
        this.nowChooseLanguage = nowChooseLanguage;
    }

    public static LanguageData getFromLocal(Context context, String defLanguage_type) {
        SharedPreferences sp = context.getSharedPreferences("language", 0);
        String language_type = sp.getString("language_type", defLanguage_type);
        String language_text = sp.getString("language_text", "");
        String nowChooseLanguage = sp.getString("nowChooseLanguage", "def");
        LanguageData mLanguageData = new LanguageData(language_text, nowChooseLanguage);
        mLanguageData.setLanguage_type(language_type);
        return mLanguageData;
    }

    public static void saveToLocal(LanguageData languageData, Context context) {
        SharedPreferences sp = context.getSharedPreferences("language", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("language_text", languageData.language_text);
        editor.putString("nowChooseLanguage", languageData.nowChooseLanguage);
        editor.putString("language_type", languageData.language_type);
        editor.commit();
    }

    public static void updateSystemLanguage(String systemLanguage, Context context) {
        SharedPreferences sp = context.getSharedPreferences("language", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("systemLanguage", systemLanguage);
        editor.commit();
    }

    public static String getSystemLanguage(Context context) {
        SharedPreferences sp = context.getSharedPreferences("language", 0);
        String systemLanguage = sp.getString("systemLanguage", "");
        return systemLanguage;
    }
}

