/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.danmaku;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.service.danmaku.DanmaKuManager;
import com.vhall.appui.baselib.service.danmaku.IBaseDanmaku;
import com.vhall.appui.baselib.service.danmaku.IDanmaku;
import com.vhall.appui.baselib.service.danmaku.IDanmakuCallback;

public class IDanmakuView
extends FrameLayout
implements IDanmaku {
    private IDanmaku proxy;

    public IDanmakuView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public IDanmakuView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public IDanmakuView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        if (DanmaKuManager.getInstance().isLoaded()) {
            this.proxy = DanmaKuManager.getInstance().createDanmakuView(this.getContext());
            this.addView((View)this.proxy);
        } else {
            this.proxy = new IDanmaku.SimpleDanmaKu();
            this.setVisibility(8);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public void start() {
        this.proxy.start();
    }

    @Override
    public void hide() {
        this.proxy.hide();
    }

    @Override
    public void prepare() {
        this.proxy.prepare();
    }

    @Override
    public void showFPS(boolean fps) {
        this.proxy.showFPS(fps);
    }

    @Override
    public void enableDanmakuDrawingCache(boolean cache) {
        this.proxy.enableDanmakuDrawingCache(cache);
    }

    @Override
    public boolean isPrepared() {
        return this.proxy.isPrepared();
    }

    @Override
    public void setTime(long time) {
        this.proxy.setTime(time);
    }

    @Override
    public void addDanmaku(IBaseDanmaku danmaku) {
        this.proxy.addDanmaku(danmaku);
    }

    @Override
    public void pause() {
        this.proxy.pause();
    }

    @Override
    public void resume() {
        this.proxy.resume();
    }

    @Override
    public void release() {
        this.proxy.release();
    }

    @Override
    public void setCallback(IDanmakuCallback callback) {
        this.proxy.setCallback(callback);
    }

    @Override
    public void show() {
        this.proxy.show();
    }

    @Override
    public boolean isShown() {
        return this.proxy.isShown();
    }
}

