/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.danmaku;

public interface IBaseDanmaku {
    default public CharSequence getText() {
        return null;
    }

    default public int getTextColor() {
        return 0;
    }

    default public float getTextSize() {
        return 0.0f;
    }

    default public long getTime() {
        return 0L;
    }

    default public int getBorderColor() {
        return 0;
    }

    default public int getTextCountLimit() {
        return 0;
    }

    public static class Builder {
        private CharSequence text;
        private int color = -1;
        private float textSize;
        private long time;
        private int borderColor = 0;
        private int textCount = 30;

        public Builder addText(CharSequence text) {
            this.text = text;
            return this;
        }

        public Builder setTextColor(int color2) {
            this.color = color2;
            return this;
        }

        public Builder setTextSize(float size) {
            this.textSize = size;
            return this;
        }

        public Builder setTime(long time) {
            this.time = time;
            return this;
        }

        public Builder setBorderColor(int borderColor) {
            this.borderColor = borderColor;
            return this;
        }

        private Builder setTextCountLimit(int textCount) {
            this.textCount = textCount;
            return this;
        }

        public IBaseDanmaku build() {
            return new IBaseDanmaku(){

                @Override
                public CharSequence getText() {
                    text = text == null ? "" : text;
                    if (text.length() > textCount) {
                        text = String.format("%s...", text.subSequence(0, textCount));
                    }
                    return text;
                }

                @Override
                public int getTextColor() {
                    return color;
                }

                @Override
                public float getTextSize() {
                    return textSize;
                }

                @Override
                public long getTime() {
                    return time;
                }

                @Override
                public int getBorderColor() {
                    return borderColor;
                }

                @Override
                public int getTextCountLimit() {
                    return textCount;
                }
            };
        }
    }
}

