/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.chat;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.vhall.appui.baselib.service.chat.ChatManager;
import com.vhall.appui.baselib.service.chat.IChatBottomControl;
import com.vhall.appui.baselib.service.chat.IChatPanel;
import com.vhall.appui.baselib.service.chat.IMessageMenuListener;
import com.vhall.appui.baselib.service.chat.OnItemChildClickListener;
import com.vhall.appui.baselib.service.chat.OnItemChildLongClickListener;
import com.vhall.appui.baselib.service.chat.OnItemClickListener;
import com.vhall.appui.baselib.vss.data.MessageData;
import com.vhall.appui.baselib.vss.service.IMessage;
import com.vhall.appui.chat.widget.ChatPanelView;
import java.util.List;

public class IChatPanelView
extends FrameLayout
implements IChatPanel {
    private IChatPanel proxy;

    public IChatPanelView(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public IChatPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public IChatPanelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        if (ChatManager.getInstance().isLoaded()) {
            this.proxy = ChatManager.getInstance().createChatPanel(context, attrs, defStyleAttr);
            this.addView((View)this.proxy);
        } else {
            this.proxy = new IChatPanel.SimpleDefaultChatPanel();
            super.setVisibility(8);
        }
    }

    @Override
    public void setNewMessage(ChatPanelView.NewMessageCallback newMessageCallback) {
        if (ChatManager.getInstance().isLoaded()) {
            this.proxy.setNewMessage(newMessageCallback);
        }
    }

    public void setNewMessageClick() {
        if (ChatManager.getInstance().isLoaded()) {
            this.proxy.click();
        }
    }

    @Override
    public void addMessage(IMessage message) {
        this.proxy.addMessage(message);
    }

    @Override
    public void addMessage(List<IMessage> messages) {
        this.proxy.addMessage(messages);
    }

    @Override
    public void addSpecialMessage(MessageData info) {
        this.proxy.addSpecialMessage(info);
    }

    @Override
    public void removeMessage(IMessage message) {
        this.proxy.removeMessage(message);
    }

    @Override
    public void setVisible(boolean show) {
        this.proxy.setVisible(show);
    }

    @Override
    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.proxy.setOnItemClickListener(onItemClickListener);
    }

    @Override
    public void setOnItemChildLongClickListener(OnItemChildLongClickListener onItemChildLongClickListener) {
        this.proxy.setOnItemChildLongClickListener(onItemChildLongClickListener);
    }

    @Override
    public void OnItemChildClickListener(OnItemChildClickListener onItemChildClickListener) {
        this.proxy.OnItemChildClickListener(onItemChildClickListener);
    }

    @Override
    public void setMessageMenuListener(IMessageMenuListener messageMenuListener) {
        this.proxy.setMessageMenuListener(messageMenuListener);
    }

    @Override
    public void setBottomControl(IChatBottomControl chatBottomControl) {
        this.proxy.setBottomControl(chatBottomControl);
    }
}

