/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.chat;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vhall.appui.baselib.service.chat.ChatManager;
import com.vhall.appui.baselib.service.chat.IChatBottomControl;
import com.vhall.appui.baselib.service.chat.IInputListener;

public class IChatBottomControlView
extends FrameLayout
implements IChatBottomControl {
    private IChatBottomControl proxy;

    public IChatBottomControlView(@NonNull Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public IChatBottomControlView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    public IChatBottomControlView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        if (ChatManager.getInstance().isLoaded()) {
            this.proxy = ChatManager.getInstance().createChatView(context, attrs, defStyleAttr);
            this.addView((View)this.proxy);
        } else {
            this.proxy = new IChatBottomControl.SimpleChatBottomControl();
            super.setVisibility(8);
        }
    }

    @Override
    public void showKeyboard() {
        this.proxy.showKeyboard();
    }

    @Override
    public void hintKeyboard() {
        this.proxy.hintKeyboard();
    }

    @Override
    public void setChatAble(boolean canChat, String hint) {
        this.proxy.setChatAble(canChat, hint);
    }

    @Override
    public boolean isChatControlVisible() {
        return this.proxy.isChatControlVisible();
    }

    @Override
    public void setSendMessage(String msg) {
        this.proxy.setSendMessage(msg);
    }

    @Override
    public void setInputListener(IInputListener inputListener) {
        this.proxy.setInputListener(inputListener);
    }
}

