/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.service.chat;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import com.vhall.appui.baselib.core.SimpleManager;
import com.vhall.appui.baselib.service.chat.IChatBottomControl;
import com.vhall.appui.baselib.service.chat.IChatPanel;
import com.vhall.appui.baselib.service.chat.IChatService;
import com.vhall.appui.baselib.service.chat.processor.IVHChatInterceptor;
import com.vhall.appui.baselib.utils.Singleton;
import com.vhall.appui.baselib.vss.CallBack;
import java.util.ArrayList;
import java.util.List;

public final class ChatManager
extends SimpleManager<IChatService> {
    private static final Singleton<ChatManager> CHAT_MANAGER = new Singleton<ChatManager>(){

        @Override
        protected ChatManager create() {
            return new ChatManager();
        }
    };

    public static ChatManager getInstance() {
        return CHAT_MANAGER.get();
    }

    @Override
    public String getComponentsName() {
        return "chat";
    }

    public IChatPanel createChatPanel(Context uiContext, AttributeSet attrs, int defStyleAttr) {
        if (this.service != null) {
            return ((IChatService)this.service).createChatPanel(uiContext, attrs, defStyleAttr);
        }
        return null;
    }

    public IChatBottomControl createChatView(Context uiContext, AttributeSet attrs, int defStyleAttr) {
        if (this.service != null) {
            return ((IChatService)this.service).createChatView(uiContext, attrs, defStyleAttr);
        }
        return null;
    }

    public void startChatActivity(Context activity, Bundle bundle) {
        if (null != this.service) {
            ((IChatService)this.service).startChatActivity(activity, bundle);
        }
    }

    public void uploadImage(List<String> images, CallBack<List<String>> callBack) {
        if (null != this.service) {
            ((IChatService)this.service).uploadImage(images, callBack);
        }
    }

    public void addVHChatInterceptor(IVHChatInterceptor interceptor) {
        if (null != this.service) {
            ((IChatService)this.service).addVHChatInterceptor(interceptor);
        }
    }

    public List<IVHChatInterceptor> getVHChatInterceptors() {
        if (null != this.service) {
            return ((IChatService)this.service).getVHChatInterceptors();
        }
        return new ArrayList<IVHChatInterceptor>();
    }

    public boolean isAddedChatInterceptor(String serviceName) {
        if (null != this.service) {
            return ((IChatService)this.service).isAddedChatEventInterceptor(serviceName);
        }
        return false;
    }
}

