/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.net.utils;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.service.hostmanage.HostManageManager;
import com.vhall.appui.baselib.service.language.LanguageManager;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.utils.ActivityCollector;
import com.vhall.appui.baselib.vss.CallBack;
import com.vhall.appui.baselib.vss.data.ResponseJe;
import com.vhall.appui.baselib.vss.utils.exception.ApiException;
import com.vhall.appui.baselib.vss.utils.exception.CustomException;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.VHNetResponse;

public class CoreNetCallback<T>
implements IVHNetCallback {
    public static final int ERROR_CODE_LOGIN = 401;
    public static final int ERROR_CODE_HOST_MANAGE_LOGIN = 30002;
    private CallBack callback;
    private Class<T> clz;
    private Bundle bundle;

    public CoreNetCallback(CallBack callback) {
        this.callback = callback;
    }

    public CoreNetCallback(CallBack callback, Class<T> clz) {
        this.callback = callback;
        this.clz = clz;
    }

    public void onFailure(VHNetResponse response, Exception e) {
        if (this.callback != null) {
            ApiException exception = CustomException.handleException(response.getResponseCode(), e);
            this.callback.onError(exception.getCode(), exception.getMessage());
        }
    }

    public void response(VHNetResponse response) {
        if (this.callback != null && response != null) {
            ResponseJe<T> data = new ResponseJe<T>(response.getResult(), this.clz);
            int code = data.getCode();
            if (code == 401) {
                AccountManager.getInstance().logOut(new Bundle());
            }
            if (code == 30002 && HostManageManager.getInstance().isLoaded()) {
                ActivityCollector.finishAll();
                AccountManager.getInstance().logOut(null);
                if (HostManageManager.getInstance().isLoaded()) {
                    HostManageManager.getInstance().startLogin((Context)M.context, new Bundle());
                }
                AccountManager.getInstance().startLogin((Context)M.context, null);
            }
            if (code != 200) {
                if (!TextUtils.isEmpty((CharSequence)data.getKey()) && !TextUtils.isEmpty((CharSequence)LanguageManager.getStringId(data.getKey()))) {
                    this.callback.onError(data.getCode(), LanguageManager.getStringId(data.getKey()));
                    return;
                }
                this.callback.onError(data.getCode(), data.getMsg());
                return;
            }
            if (null != this.clz) {
                this.callback.onSuccess(data.getData());
            } else {
                this.callback.onSuccess(response.getResult());
            }
        }
    }
}

