/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.net.utils;

import android.text.TextUtils;
import com.vhall.appui.baselib.CommonManager;
import com.vhall.appui.baselib.M;
import com.vhall.appui.baselib.VhSdk;
import com.vhall.appui.baselib.net.CloudApiConstant;
import com.vhall.appui.baselib.net.Md5Encode;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.appui.baselib.vss.module.room.VssRoomManager;
import com.vhall.appui.baselib.vss.utils.rxutils.BaseVhallVssHttp;
import com.vhall.httpclient.core.IVHRequest;
import java.util.Arrays;
import java.util.HashMap;

public class BaseNetwork {
    public static String createVssUrl(String api) {
        if (api.contains("http")) {
            return api;
        }
        if (!TextUtils.isEmpty((CharSequence)api) && api.startsWith("/")) {
            return String.format("%s%s", CommonManager.getInstance(M.context).getBaseConfig().getHost(), api);
        }
        return String.format("%s/%s", CommonManager.getInstance(M.context).getBaseConfig().getHost(), api);
    }

    public static HashMap<String, String> getSignParam(HashMap<String, String> params) {
        if (params == null) {
            params = new HashMap();
        }
        params.put("signed_at", String.valueOf(System.currentTimeMillis() / 1000L));
        params.put("token", AccountManager.getInstance().getToken());
        params.put("from", "android");
        params.put("app_id", CommonManager.getInstance(M.context).getBaseConfig().getAppId());
        if (!params.containsKey("room_id") && !TextUtils.isEmpty((CharSequence)VssRoomManager.getInstance().getRoomInfo().getRoom_id())) {
            params.put("room_id", VssRoomManager.getInstance().getRoomInfo().getRoom_id());
        }
        if (!params.containsKey("il_id") && !TextUtils.isEmpty((CharSequence)VssRoomManager.getInstance().getRoomInfo().getIl_id())) {
            params.put("il_id", VssRoomManager.getInstance().getRoomInfo().getIl_id());
        }
        if (!params.containsKey("vss_token") && !TextUtils.isEmpty((CharSequence)BaseVhallVssHttp.vssToken)) {
            params.put("vss_token", BaseVhallVssHttp.vssToken);
        }
        if (!params.containsKey("account_id")) {
            params.put("account_id", AccountManager.getInstance().getUserId());
        }
        if (!params.containsKey("adsdk_version")) {
            params.put("adsdk_version", VhSdk.getInstance().getVHSDKVersion() + "");
        }
        Object[] key = params.keySet().toArray();
        Arrays.sort(key);
        String param = CloudApiConstant.SECRET_KEY;
        for (int i = 0; i < key.length; ++i) {
            param = param + key[i] + params.get(key[i]);
        }
        param = param + CloudApiConstant.SECRET_KEY;
        String sign = Md5Encode.getMD5(param);
        params.put("sign", sign);
        return params;
    }

    public static IVHRequest getBaseRequest(HashMap<String, String> params, String apiUrl) {
        IVHRequest.Builder builder = new IVHRequest.Builder();
        builder.setUrl(BaseNetwork.createVssUrl(apiUrl)).addHeader("token", TextUtils.isEmpty((CharSequence)AccountManager.getInstance().getToken()) ? "" : AccountManager.getInstance().getToken()).addHeader("vsstoken", TextUtils.isEmpty((CharSequence)BaseVhallVssHttp.vssToken) ? "" : BaseVhallVssHttp.vssToken).addFormParas(params);
        return builder.addFormParas(BaseNetwork.getSignParam(params)).build();
    }
}

