/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.appui.baselib.net;

import com.vhall.appui.baselib.net.CloudApi;
import com.vhall.appui.baselib.net.CloudApiConstant;
import com.vhall.appui.baselib.net.Md5Encode;
import com.vhall.appui.baselib.service.login.AccountManager;
import com.vhall.httpclient.utils.OKHttpUtils;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.fastjson.FastJsonConverterFactory;

public class CloudHttpManager {
    private CloudApi apiService;
    private static Retrofit retrofit;
    private static OkHttpClient okHttpClient;
    private static volatile CloudHttpManager instance;

    private CloudHttpManager() {
        this.initOkHttp();
        this.initRetrofit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloudHttpManager getInstance() {
        if (instance != null) return instance;
        Class<CloudHttpManager> clazz = CloudHttpManager.class;
        synchronized (CloudHttpManager.class) {
            if (instance != null) return instance;
            instance = new CloudHttpManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initOkHttp() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        okHttpClient = OKHttpUtils.createOkClient();
    }

    private void initRetrofit() {
        retrofit = new Retrofit.Builder().client(okHttpClient).baseUrl(CloudApiConstant.API_HOST + "/" + CloudApiConstant.API_AREA + "/").addConverterFactory((Converter.Factory)FastJsonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
        this.apiService = (CloudApi)retrofit.create(CloudApi.class);
    }

    public CloudApi getApiService() {
        return this.apiService;
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ssfFactory;
    }

    public static Map<String, String> getParam(Map<String, String> params) {
        Object[] key = params.keySet().toArray();
        Arrays.sort(key);
        String param = CloudApiConstant.SECRET_KEY;
        for (int i = 0; i < key.length; ++i) {
            param = param + key[i] + params.get(key[i]);
        }
        param = param + CloudApiConstant.SECRET_KEY;
        String sign = Md5Encode.getMD5(param);
        params.put("sign", sign);
        return params;
    }

    public static RequestBody getRequestBody(Map<String, String> hashMap) {
        hashMap.put("signed_at", String.valueOf(System.currentTimeMillis() / 1000L));
        hashMap.put("from", "android");
        hashMap.put("token", AccountManager.getInstance().getToken());
        hashMap = CloudHttpManager.getParam(hashMap);
        String param = "";
        FormBody.Builder builder = new FormBody.Builder();
        for (String key : hashMap.keySet()) {
            param = param + key + ":" + hashMap.get(key) + " ";
            builder.add(key, hashMap.get(key) == null ? "" : hashMap.get(key));
        }
        return builder.build();
    }

    static {
        okHttpClient = null;
    }

    private static class TrustAllHostnameVerifier
    implements HostnameVerifier {
        private TrustAllHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class TrustAllCerts
    implements X509TrustManager {
        private TrustAllCerts() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

